/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.symtab;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.DebugLineParser;
import com.uqm.crashsight.symtabtool.symtab.SymbolEntry;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Symbol {
    public static final String SEPARATOR = "\t";
    public static final String NO_FUNCTION = "NoFunction";
    public static final String INLINE_INNER_SEPARATOR = "!";
    public static final String INLINE_SEPARATOR = ";";
    public static char FILE_SEPARATOR = (char)47;
    public boolean fixedVmAddr = false;
    private long address = -1L;
    private long endAddress = 0L;
    private String function = null;
    private String sourceFile = null;
    private long sourceline = -1L;
    private long sourceEndLine = -1L;
    private long sourceColumn = -1L;
    private List<SymbolEntry> entries = null;

    public Symbol() {
    }

    public Symbol(DebugLineParser.DebugLineEntry lineInfo, Subroutine subroutine) {
        this.setAddress(lineInfo.getAddress());
        this.setSourceFile(lineInfo.getPathName());
        this.setSourceLine(lineInfo.getLineNumber());
        this.setSourceEndLine(lineInfo.getEndLineNumber());
        this.setSourceColumn(lineInfo.getColumnNumber());
        this.setFunction(subroutine.getName());
        this.setEndAddress(subroutine.getHighPc());
    }

    public boolean hasFunctionName() {
        return null != this.function;
    }

    public long getAddress() {
        return this.address;
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public void setEndAddress(long endAddress) {
        this.endAddress = endAddress;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String srcFile) {
        this.sourceFile = srcFile;
    }

    public long getSourceLine() {
        return this.sourceline;
    }

    public void setSourceLine(long line) {
        this.sourceline = line;
    }

    public long getSourceEndLine() {
        return this.sourceEndLine;
    }

    public void setSourceEndLine(long endLine) {
        this.sourceEndLine = endLine;
    }

    public long getSourceColumn() {
        return this.sourceColumn;
    }

    public void setSourceColumn(long sourceColumn) {
        this.sourceColumn = sourceColumn;
    }

    public List<SymbolEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<SymbolEntry> entries) {
        this.entries = entries;
    }

    public Symbol parseString(String line) {
        try {
            if (line.contains("\n")) {
                line = line.substring(0, line.indexOf("\n"));
            }
            String[] array = line.split(SEPARATOR);
            this.address = Long.parseLong(array[0], 16);
            this.endAddress = Long.parseLong(array[1], 16);
            this.function = array[2];
            if (this.function.equals(NO_FUNCTION)) {
                this.function = null;
            }
            if (array.length > 3) {
                this.sourceFile = array[3];
                this.sourceline = Long.parseLong(array[4]);
                this.sourceEndLine = Long.parseLong(array[5]);
                this.sourceColumn = Long.parseLong(array[6]);
            }
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public Symbol parseStringLast(String line) {
        this.parseString(line);
        return this.transformSymbol();
    }

    public Symbol transformSymbol() {
        String[] array;
        String dirStr = "";
        String fileStr = "";
        StringBuilder lineStr = new StringBuilder();
        if (!StringUtils.isEmpty(this.sourceFile)) {
            if (this.sourceFile.contains(":\\")) {
                if (this.sourceFile.lastIndexOf("\\") != -1) {
                    dirStr = this.sourceFile.substring(0, this.sourceFile.lastIndexOf("\\"));
                    fileStr = this.sourceFile.substring(this.sourceFile.lastIndexOf("\\") + 1, this.sourceFile.length());
                } else {
                    Log.error("error src line info %s", this.sourceFile);
                }
            } else {
                try {
                    Path path = Paths.get(this.sourceFile, new String[0]);
                    if (path.getParent() != null) {
                        dirStr = path.getParent().toString();
                        fileStr = path.getFileName().toString();
                    } else {
                        dirStr = "";
                        fileStr = "";
                    }
                }
                catch (Exception e) {
                    Log.error("Unable to parse path %s", this.sourceFile);
                    dirStr = "";
                    fileStr = "";
                }
            }
            if (StringUtils.isNotEmpty(fileStr)) {
                lineStr.append(this.sourceline);
                if (-1L != this.sourceEndLine) {
                    lineStr.append("-").append(this.sourceEndLine);
                }
                if (-1L != this.sourceColumn) {
                    lineStr.append(":").append(this.sourceColumn);
                }
            }
        }
        this.entries = new ArrayList<SymbolEntry>();
        if (this.function == null) {
            this.function = NO_FUNCTION;
        }
        if ((array = this.function.split(INLINE_SEPARATOR)).length == 1) {
            this.entries.add(SymbolEntry.create(dirStr, fileStr, this.function, lineStr.toString()));
        } else {
            int i = 0;
            for (i = 0; i < array.length - 1; ++i) {
                String[] array2 = array[i].split(INLINE_INNER_SEPARATOR);
                if (array2.length == 1) {
                    this.entries.add(SymbolEntry.create("", "", array2[0], ""));
                    continue;
                }
                if (array2.length != 3) {
                    Log.error("inline parse error: " + this, new Object[0]);
                    continue;
                }
                int index2 = array2[1].lastIndexOf(47);
                this.entries.add(SymbolEntry.create(array2[1].substring(0, index2), array2[1].substring(index2 + 1), array2[0], array2[2]));
            }
            this.entries.add(SymbolEntry.create(dirStr, fileStr, array[i], lineStr.toString()));
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (-1L == this.address) {
            Log.error("The symbol has no address!", new Object[0]);
            return null;
        }
        stringBuilder.append(Long.toHexString(this.address));
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(Long.toHexString(this.endAddress));
        stringBuilder.append(SEPARATOR);
        if (null != this.function) {
            stringBuilder.append(this.function);
        } else {
            stringBuilder.append(NO_FUNCTION);
        }
        if (null != this.sourceFile) {
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.sourceFile);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.sourceline);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.sourceEndLine);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.sourceColumn);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String getSrcLineString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != this.sourceFile) {
            stringBuilder.append(this.sourceFile);
            stringBuilder.append("->");
            stringBuilder.append(this.sourceline);
            if (-1L != this.sourceEndLine) {
                stringBuilder.append("-");
                stringBuilder.append(this.sourceEndLine);
            }
        }
        return stringBuilder.toString();
    }

    public boolean contain(Symbol symbol) {
        return symbol.address >= this.address && symbol.endAddress <= this.endAddress;
    }

    public boolean contain(long address) {
        return address >= this.address && address < this.endAddress;
    }

    public boolean equals(Symbol symbol) {
        if (symbol.address != symbol.address) {
            return false;
        }
        if (!symbol.sourceFile.equals(this.sourceFile)) {
            return false;
        }
        if (symbol.sourceline != this.sourceline) {
            return false;
        }
        return symbol.sourceEndLine == this.sourceEndLine;
    }
}

