/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pe.RuntimeFunction;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.StackFrameOffset;
import com.uqm.crashsight.symtabtool.pe.UnwindCode;
import com.uqm.crashsight.symtabtool.pe.UnwindInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Stack;
import org.apache.commons.codec.binary.Hex;

public class peStack {
    private static byte[] buffer;

    public static int littleRead(int offset, int length) {
        int ret = 0;
        --length;
        while (length >= 0) {
            ret = ret * 256 + (buffer[offset + length] & 0xFF);
            --length;
        }
        return ret;
    }

    public static String getStack(String pdbName, String debugId) {
        int i;
        StringBuilder stackCFI = new StringBuilder();
        String peName = pdbName.substring(0, pdbName.length() - 4) + ".dll";
        File file = new File(peName);
        long fileSize = file.length();
        buffer = new byte[(int)fileSize];
        try {
            int numRead;
            FileInputStream fi = new FileInputStream(file);
            for (int offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
            }
            fi.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int NTHeadAddr = peStack.littleRead(60, 4);
        int NumberOfSections = peStack.littleRead(NTHeadAddr + 6, 2);
        int SizeOfOptionalHeader = peStack.littleRead(NTHeadAddr + 20, 2);
        int optionalHeaderAddr = NTHeadAddr + 24;
        int FileAlignment = peStack.littleRead(optionalHeaderAddr + 36, 4);
        int sectionTableAddr = optionalHeaderAddr + SizeOfOptionalHeader;
        int DataDirectoryAddr = optionalHeaderAddr + 112;
        int DEBUGDirectoryAddr = DataDirectoryAddr + 48;
        int DEBUGDirectoryVirtualAddress = peStack.littleRead(DEBUGDirectoryAddr, 4);
        int DEBUGDirectorySize = peStack.littleRead(DEBUGDirectoryAddr + 4, 4);
        Section[] sectionTable = new Section[NumberOfSections];
        int pdata_num = 3;
        for (i = 0; i < NumberOfSections; ++i) {
            sectionTable[i] = new Section();
            for (int j = 0; j < 8; ++j) {
                sectionTable[i].nameChar[j] = (char)buffer[sectionTableAddr + 40 * i + j];
            }
            char[] ary = new char[]{'.', 'p', 'd', 'a', 't', 'a', '\u0000', '\u0000'};
            if (Arrays.equals(ary, sectionTable[i].nameChar)) {
                pdata_num = i;
            }
            sectionTable[i].virtualSize = peStack.littleRead(sectionTableAddr + 40 * i + 8, 4);
            sectionTable[i].virtualAddress = peStack.littleRead(sectionTableAddr + 40 * i + 12, 4);
            sectionTable[i].sizeOfRawData = peStack.littleRead(sectionTableAddr + 40 * i + 16, 4);
            sectionTable[i].pointerToRawData = peStack.littleRead(sectionTableAddr + 40 * i + 20, 4);
        }
        for (i = 0; i < NumberOfSections; ++i) {
            if (!sectionTable[i].is_in_section(DEBUGDirectoryVirtualAddress, FileAlignment)) continue;
            int offset = new Long((long)DEBUGDirectoryVirtualAddress - sectionTable[i].virtualAddress + (sectionTable[i].pointerToRawData & 0xFFFFFFFFFFFFFE00L) + 24L).intValue();
            byte v1 = buffer[offset++];
            byte v2 = buffer[offset++];
            byte v3 = buffer[offset++];
            byte v4 = buffer[offset];
            int addr = (v1 & 0xFF) + (v2 & 0xFF) * 256 + (v3 & 0xFF) * 256 * 256 + (v4 & 0xFF) * 256 * 256 * 256;
            addr += 4;
            byte[] signature = new byte[16];
            for (int j = 0; j < 16; ++j) {
                signature[j] = buffer[addr++];
            }
            byte[] signature2 = new byte[16];
            signature2[0] = signature[3];
            signature2[1] = signature[2];
            signature2[2] = signature[1];
            signature2[3] = signature[0];
            signature2[4] = signature[5];
            signature2[5] = signature[4];
            signature2[6] = signature[7];
            signature2[7] = signature[6];
            System.arraycopy(signature, 8, signature2, 8, 8);
            v1 = buffer[addr++];
            v2 = buffer[addr++];
            v3 = buffer[addr++];
            v4 = buffer[addr];
            int age = (v1 & 0xFF) + (v2 & 0xFF) * 256 + (v3 & 0xFF) * 256 * 256 + (v4 & 0xFF) * 256 * 256 * 256;
            String uuidStr = Hex.encodeHexString(signature2).toUpperCase() + age;
            if (!uuidStr.equals(debugId)) {
                Log.info("Correct exe file not found! Cannot parse stack info.", new Object[0]);
                return "";
            }
            Log.info("Correct exe file found! Begin to parse stack info.", new Object[0]);
            break;
        }
        RuntimeFunction[] functions = new RuntimeFunction[new Long(sectionTable[pdata_num].virtualSize / 12L).intValue()];
        int i2 = 0;
        while ((long)i2 < sectionTable[pdata_num].virtualSize / 12L) {
            functions[i2] = new RuntimeFunction();
            functions[i2].beginAddr = peStack.littleRead(new Long(sectionTable[pdata_num].pointerToRawData + (long)(i2 * 12)).intValue(), 4);
            functions[i2].endAddr = peStack.littleRead(new Long(sectionTable[pdata_num].pointerToRawData + (long)(i2 * 12) + 4L).intValue(), 4);
            functions[i2].unwind_info_addr = peStack.littleRead(new Long(sectionTable[pdata_num].pointerToRawData + (long)(i2 * 12) + 8L).intValue(), 4);
            ++i2;
        }
        StringBuilder cfa_reg = new StringBuilder();
        StringBuilder saved_regs = new StringBuilder();
        Stack<UnwindCode> codes = new Stack<UnwindCode>();
        for (RuntimeFunction func : functions) {
            if (func.beginAddr == 0L && func.endAddr == 0L && func.unwind_info_addr == 0L || func.beginAddr > func.endAddr) continue;
            int stack_size = 8;
            int machine_frame_offset = 0;
            cfa_reg.delete(0, cfa_reg.length());
            saved_regs.delete(0, saved_regs.length());
            RuntimeFunction next_function = func;
            while (next_function != null) {
                int i3;
                UnwindInfo unwind_info = new UnwindInfo();
                for (i3 = 0; i3 < NumberOfSections; ++i3) {
                    if (!sectionTable[i3].is_in_section(next_function.unwind_info_addr, FileAlignment)) continue;
                    int UnwindInfoOffset = new Long(next_function.unwind_info_addr - sectionTable[i3].virtualAddress + (sectionTable[i3].pointerToRawData & 0xFFFFFFFFFFFFFE00L)).intValue();
                    unwind_info.parse(buffer, UnwindInfoOffset);
                    break;
                }
                i3 = 0;
                while (i3 < unwind_info.code_bytes.length) {
                    UnwindCode code = new UnwindCode();
                    i3 = code.parse(unwind_info.code_bytes, i3, unwind_info.frame_register);
                    codes.push(code);
                }
                while (!codes.empty()) {
                    UnwindCode code = (UnwindCode)codes.peek();
                    switch (code.operation) {
                        case SaveNonVolatile: {
                            if (code.sfo == StackFrameOffset.RSP) {
                                saved_regs.append(" ").append(code.getRegisterName()).append(": .cfa ").append(stack_size - code.offset).append(" - ^");
                                break;
                            }
                            if (code.sfo != StackFrameOffset.FP) break;
                            saved_regs.append(" ").append(code.getRegisterName()).append(": ").append(unwind_info.getFrameRegisterName()).append(" ").append(code.offset - unwind_info.frame_register_offset).append(" + ^");
                            break;
                        }
                        case PushNonVolatile: {
                            saved_regs.append(" ").append(code.getRegisterName()).append(": .cfa ").append(stack_size += 8).append(" - ^");
                            break;
                        }
                        case Alloc: {
                            stack_size += code.offset;
                            break;
                        }
                        case SetFPRegister: {
                            int off = stack_size - unwind_info.frame_register_offset;
                            cfa_reg.append(".cfa: ").append(unwind_info.getFrameRegisterName()).append(" ").append(off).append(" +");
                            break;
                        }
                        case PushMachineFrame: {
                            int rsp_offset = stack_size + 16;
                            int rip_offset = stack_size + 40;
                            saved_regs.append(" $rsp: .cfa ").append(rsp_offset).append(" - ^ .ra: .cfa ").append(rip_offset).append(" - ^");
                            machine_frame_offset = stack_size += 40;
                            if (!code.is_error) break;
                            stack_size += 8;
                            break;
                        }
                    }
                    codes.pop();
                }
                next_function = unwind_info.chained_info;
            }
            if (cfa_reg.length() == 0) {
                cfa_reg.append(".cfa: $rsp ").append(stack_size).append(" +");
            }
            if (machine_frame_offset == 0) {
                saved_regs.append(" .ra: .cfa 8 - ^");
            }
            stackCFI.append("STACK CFI INIT ").append(Long.toHexString(func.beginAddr)).append(" ").append(Long.toHexString(func.endAddr - func.beginAddr)).append(" ");
            stackCFI.append((CharSequence)cfa_reg);
            stackCFI.append((CharSequence)saved_regs);
            stackCFI.append("\n");
        }
        return stackCFI.toString();
    }
}

