/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe.header;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class WindowsFields {
    long image_base;
    long section_alignment;
    long file_alignment;
    int major_operating_system_version;
    int minor_operating_system_version;
    int major_image_version;
    int minor_image_version;
    int major_subsystem_version;
    int minor_subsystem_version;
    long win32_version_value;
    long sizeOfImage;
    long size_of_headers;
    long check_sum;
    int subsystem;
    int dll_characteristics;
    long size_of_stack_reserve;
    long size_of_stack_commit;
    long size_of_heap_reserve;
    long size_of_heap_commit;
    long loader_flags;
    long number_of_rva_and_sizes;
    private static final long SIZEOF_WINDOWS_FIELDS_64 = 88L;

    public static WindowsFields parse(ParseBuffer parseBuffer) {
        WindowsFields windowsFields = new WindowsFields();
        windowsFields.image_base = parseBuffer.readU64();
        windowsFields.section_alignment = parseBuffer.readU32();
        windowsFields.file_alignment = parseBuffer.readU32();
        windowsFields.major_operating_system_version = parseBuffer.readU16();
        windowsFields.minor_operating_system_version = parseBuffer.readU16();
        windowsFields.major_image_version = parseBuffer.readU16();
        windowsFields.minor_image_version = parseBuffer.readU16();
        windowsFields.major_subsystem_version = parseBuffer.readU16();
        windowsFields.minor_subsystem_version = parseBuffer.readU16();
        windowsFields.win32_version_value = parseBuffer.readU32();
        windowsFields.sizeOfImage = parseBuffer.readU32();
        windowsFields.size_of_headers = parseBuffer.readU32();
        windowsFields.check_sum = parseBuffer.readU32();
        windowsFields.subsystem = parseBuffer.readU16();
        windowsFields.dll_characteristics = parseBuffer.readU16();
        windowsFields.size_of_stack_reserve = parseBuffer.readU64();
        windowsFields.size_of_stack_commit = parseBuffer.readU64();
        windowsFields.size_of_heap_reserve = parseBuffer.readU64();
        windowsFields.size_of_heap_commit = parseBuffer.readU64();
        windowsFields.loader_flags = parseBuffer.readU32();
        windowsFields.number_of_rva_and_sizes = parseBuffer.readU32();
        return windowsFields;
    }

    public long getImage_base() {
        return this.image_base;
    }

    public long getSection_alignment() {
        return this.section_alignment;
    }

    public long getFile_alignment() {
        return this.file_alignment;
    }

    public int getMajor_operating_system_version() {
        return this.major_operating_system_version;
    }

    public int getMinor_operating_system_version() {
        return this.minor_operating_system_version;
    }

    public int getMajor_image_version() {
        return this.major_image_version;
    }

    public int getMinor_image_version() {
        return this.minor_image_version;
    }

    public int getMajor_subsystem_version() {
        return this.major_subsystem_version;
    }

    public int getMinor_subsystem_version() {
        return this.minor_subsystem_version;
    }

    public long getWin32_version_value() {
        return this.win32_version_value;
    }

    public long getSizeOfImage() {
        return this.sizeOfImage;
    }

    public long getSize_of_headers() {
        return this.size_of_headers;
    }

    public long getCheck_sum() {
        return this.check_sum;
    }

    public int getSubsystem() {
        return this.subsystem;
    }

    public int getDll_characteristics() {
        return this.dll_characteristics;
    }

    public long getSize_of_stack_reserve() {
        return this.size_of_stack_reserve;
    }

    public long getSize_of_stack_commit() {
        return this.size_of_stack_commit;
    }

    public long getSize_of_heap_reserve() {
        return this.size_of_heap_reserve;
    }

    public long getSize_of_heap_commit() {
        return this.size_of_heap_commit;
    }

    public long getLoader_flags() {
        return this.loader_flags;
    }

    public long getNumber_of_rva_and_sizes() {
        return this.number_of_rva_and_sizes;
    }

    public void setImage_base(long image_base) {
        this.image_base = image_base;
    }

    public void setSection_alignment(long section_alignment) {
        this.section_alignment = section_alignment;
    }

    public void setFile_alignment(long file_alignment) {
        this.file_alignment = file_alignment;
    }

    public void setMajor_operating_system_version(int major_operating_system_version) {
        this.major_operating_system_version = major_operating_system_version;
    }

    public void setMinor_operating_system_version(int minor_operating_system_version) {
        this.minor_operating_system_version = minor_operating_system_version;
    }

    public void setMajor_image_version(int major_image_version) {
        this.major_image_version = major_image_version;
    }

    public void setMinor_image_version(int minor_image_version) {
        this.minor_image_version = minor_image_version;
    }

    public void setMajor_subsystem_version(int major_subsystem_version) {
        this.major_subsystem_version = major_subsystem_version;
    }

    public void setMinor_subsystem_version(int minor_subsystem_version) {
        this.minor_subsystem_version = minor_subsystem_version;
    }

    public void setWin32_version_value(long win32_version_value) {
        this.win32_version_value = win32_version_value;
    }

    public void setSizeOfImage(long sizeOfImage) {
        this.sizeOfImage = sizeOfImage;
    }

    public void setSize_of_headers(long size_of_headers) {
        this.size_of_headers = size_of_headers;
    }

    public void setCheck_sum(long check_sum) {
        this.check_sum = check_sum;
    }

    public void setSubsystem(int subsystem) {
        this.subsystem = subsystem;
    }

    public void setDll_characteristics(int dll_characteristics) {
        this.dll_characteristics = dll_characteristics;
    }

    public void setSize_of_stack_reserve(long size_of_stack_reserve) {
        this.size_of_stack_reserve = size_of_stack_reserve;
    }

    public void setSize_of_stack_commit(long size_of_stack_commit) {
        this.size_of_stack_commit = size_of_stack_commit;
    }

    public void setSize_of_heap_reserve(long size_of_heap_reserve) {
        this.size_of_heap_reserve = size_of_heap_reserve;
    }

    public void setSize_of_heap_commit(long size_of_heap_commit) {
        this.size_of_heap_commit = size_of_heap_commit;
    }

    public void setLoader_flags(long loader_flags) {
        this.loader_flags = loader_flags;
    }

    public void setNumber_of_rva_and_sizes(long number_of_rva_and_sizes) {
        this.number_of_rva_and_sizes = number_of_rva_and_sizes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowsFields)) {
            return false;
        }
        WindowsFields other = (WindowsFields)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getImage_base() != other.getImage_base()) {
            return false;
        }
        if (this.getSection_alignment() != other.getSection_alignment()) {
            return false;
        }
        if (this.getFile_alignment() != other.getFile_alignment()) {
            return false;
        }
        if (this.getMajor_operating_system_version() != other.getMajor_operating_system_version()) {
            return false;
        }
        if (this.getMinor_operating_system_version() != other.getMinor_operating_system_version()) {
            return false;
        }
        if (this.getMajor_image_version() != other.getMajor_image_version()) {
            return false;
        }
        if (this.getMinor_image_version() != other.getMinor_image_version()) {
            return false;
        }
        if (this.getMajor_subsystem_version() != other.getMajor_subsystem_version()) {
            return false;
        }
        if (this.getMinor_subsystem_version() != other.getMinor_subsystem_version()) {
            return false;
        }
        if (this.getWin32_version_value() != other.getWin32_version_value()) {
            return false;
        }
        if (this.getSizeOfImage() != other.getSizeOfImage()) {
            return false;
        }
        if (this.getSize_of_headers() != other.getSize_of_headers()) {
            return false;
        }
        if (this.getCheck_sum() != other.getCheck_sum()) {
            return false;
        }
        if (this.getSubsystem() != other.getSubsystem()) {
            return false;
        }
        if (this.getDll_characteristics() != other.getDll_characteristics()) {
            return false;
        }
        if (this.getSize_of_stack_reserve() != other.getSize_of_stack_reserve()) {
            return false;
        }
        if (this.getSize_of_stack_commit() != other.getSize_of_stack_commit()) {
            return false;
        }
        if (this.getSize_of_heap_reserve() != other.getSize_of_heap_reserve()) {
            return false;
        }
        if (this.getSize_of_heap_commit() != other.getSize_of_heap_commit()) {
            return false;
        }
        if (this.getLoader_flags() != other.getLoader_flags()) {
            return false;
        }
        return this.getNumber_of_rva_and_sizes() == other.getNumber_of_rva_and_sizes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WindowsFields;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $image_base = this.getImage_base();
        result = result * 59 + (int)($image_base >>> 32 ^ $image_base);
        long $section_alignment = this.getSection_alignment();
        result = result * 59 + (int)($section_alignment >>> 32 ^ $section_alignment);
        long $file_alignment = this.getFile_alignment();
        result = result * 59 + (int)($file_alignment >>> 32 ^ $file_alignment);
        result = result * 59 + this.getMajor_operating_system_version();
        result = result * 59 + this.getMinor_operating_system_version();
        result = result * 59 + this.getMajor_image_version();
        result = result * 59 + this.getMinor_image_version();
        result = result * 59 + this.getMajor_subsystem_version();
        result = result * 59 + this.getMinor_subsystem_version();
        long $win32_version_value = this.getWin32_version_value();
        result = result * 59 + (int)($win32_version_value >>> 32 ^ $win32_version_value);
        long $sizeOfImage = this.getSizeOfImage();
        result = result * 59 + (int)($sizeOfImage >>> 32 ^ $sizeOfImage);
        long $size_of_headers = this.getSize_of_headers();
        result = result * 59 + (int)($size_of_headers >>> 32 ^ $size_of_headers);
        long $check_sum = this.getCheck_sum();
        result = result * 59 + (int)($check_sum >>> 32 ^ $check_sum);
        result = result * 59 + this.getSubsystem();
        result = result * 59 + this.getDll_characteristics();
        long $size_of_stack_reserve = this.getSize_of_stack_reserve();
        result = result * 59 + (int)($size_of_stack_reserve >>> 32 ^ $size_of_stack_reserve);
        long $size_of_stack_commit = this.getSize_of_stack_commit();
        result = result * 59 + (int)($size_of_stack_commit >>> 32 ^ $size_of_stack_commit);
        long $size_of_heap_reserve = this.getSize_of_heap_reserve();
        result = result * 59 + (int)($size_of_heap_reserve >>> 32 ^ $size_of_heap_reserve);
        long $size_of_heap_commit = this.getSize_of_heap_commit();
        result = result * 59 + (int)($size_of_heap_commit >>> 32 ^ $size_of_heap_commit);
        long $loader_flags = this.getLoader_flags();
        result = result * 59 + (int)($loader_flags >>> 32 ^ $loader_flags);
        long $number_of_rva_and_sizes = this.getNumber_of_rva_and_sizes();
        result = result * 59 + (int)($number_of_rva_and_sizes >>> 32 ^ $number_of_rva_and_sizes);
        return result;
    }

    public String toString() {
        return "WindowsFields(image_base=" + this.getImage_base() + ", section_alignment=" + this.getSection_alignment() + ", file_alignment=" + this.getFile_alignment() + ", major_operating_system_version=" + this.getMajor_operating_system_version() + ", minor_operating_system_version=" + this.getMinor_operating_system_version() + ", major_image_version=" + this.getMajor_image_version() + ", minor_image_version=" + this.getMinor_image_version() + ", major_subsystem_version=" + this.getMajor_subsystem_version() + ", minor_subsystem_version=" + this.getMinor_subsystem_version() + ", win32_version_value=" + this.getWin32_version_value() + ", sizeOfImage=" + this.getSizeOfImage() + ", size_of_headers=" + this.getSize_of_headers() + ", check_sum=" + this.getCheck_sum() + ", subsystem=" + this.getSubsystem() + ", dll_characteristics=" + this.getDll_characteristics() + ", size_of_stack_reserve=" + this.getSize_of_stack_reserve() + ", size_of_stack_commit=" + this.getSize_of_stack_commit() + ", size_of_heap_reserve=" + this.getSize_of_heap_reserve() + ", size_of_heap_commit=" + this.getSize_of_heap_commit() + ", loader_flags=" + this.getLoader_flags() + ", number_of_rva_and_sizes=" + this.getNumber_of_rva_and_sizes() + ")";
    }
}

