/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe.header;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.header.DataDirectories;
import com.uqm.crashsight.symtabtool.pe.header.StandardFields;
import com.uqm.crashsight.symtabtool.pe.header.WindowsFields;

public class OptionalHeader {
    StandardFields standardFields;
    WindowsFields windowsFields;
    DataDirectories dataDirectories;
    private static final long MAGIC_32 = 267L;
    private static final long MAGIC_64 = 523L;

    public static OptionalHeader parse(ParseBuffer parseBuffer) {
        OptionalHeader optionalHeader = new OptionalHeader();
        long offset = parseBuffer.pos();
        int magic = parseBuffer.readU16();
        parseBuffer.pos(offset);
        if ((long)magic == 267L) {
            optionalHeader.standardFields = StandardFields.parse(parseBuffer);
            optionalHeader.windowsFields = WindowsFields.parse(parseBuffer);
        } else if ((long)magic == 523L) {
            optionalHeader.standardFields = StandardFields.parse(parseBuffer);
            optionalHeader.windowsFields = WindowsFields.parse(parseBuffer);
        }
        optionalHeader.dataDirectories = DataDirectories.parse(parseBuffer, 8L);
        offset = parseBuffer.pos();
        return optionalHeader;
    }

    public StandardFields getStandardFields() {
        return this.standardFields;
    }

    public WindowsFields getWindowsFields() {
        return this.windowsFields;
    }

    public DataDirectories getDataDirectories() {
        return this.dataDirectories;
    }

    public void setStandardFields(StandardFields standardFields) {
        this.standardFields = standardFields;
    }

    public void setWindowsFields(WindowsFields windowsFields) {
        this.windowsFields = windowsFields;
    }

    public void setDataDirectories(DataDirectories dataDirectories) {
        this.dataDirectories = dataDirectories;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptionalHeader)) {
            return false;
        }
        OptionalHeader other = (OptionalHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StandardFields this$standardFields = this.getStandardFields();
        StandardFields other$standardFields = other.getStandardFields();
        if (this$standardFields == null ? other$standardFields != null : !this$standardFields.equals(other$standardFields)) {
            return false;
        }
        WindowsFields this$windowsFields = this.getWindowsFields();
        WindowsFields other$windowsFields = other.getWindowsFields();
        if (this$windowsFields == null ? other$windowsFields != null : !((Object)this$windowsFields).equals(other$windowsFields)) {
            return false;
        }
        DataDirectories this$dataDirectories = this.getDataDirectories();
        DataDirectories other$dataDirectories = other.getDataDirectories();
        return !(this$dataDirectories == null ? other$dataDirectories != null : !this$dataDirectories.equals(other$dataDirectories));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptionalHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StandardFields $standardFields = this.getStandardFields();
        result = result * 59 + ($standardFields == null ? 43 : $standardFields.hashCode());
        WindowsFields $windowsFields = this.getWindowsFields();
        result = result * 59 + ($windowsFields == null ? 43 : ((Object)$windowsFields).hashCode());
        DataDirectories $dataDirectories = this.getDataDirectories();
        result = result * 59 + ($dataDirectories == null ? 43 : $dataDirectories.hashCode());
        return result;
    }

    public String toString() {
        return "OptionalHeader(standardFields=" + this.getStandardFields() + ", windowsFields=" + this.getWindowsFields() + ", dataDirectories=" + this.getDataDirectories() + ")";
    }
}

