/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe.header;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.header.CoffHeader;
import com.uqm.crashsight.symtabtool.pe.header.DosHeader;
import com.uqm.crashsight.symtabtool.pe.header.OptionalHeader;

public class Header {
    DosHeader dosHeader;
    long signature;
    CoffHeader coffHeader;
    OptionalHeader optionalHeader;
    public static final long SIZEOF_PE_MAGIC = 4L;
    public static final long SIZEOF_COFF_HEADER = 20L;
    public static final long COFF_MACHINE_X86_64 = 34404L;

    public static Header parse(ParseBuffer buffer) {
        Header header = new Header();
        header.dosHeader = DosHeader.parse(buffer);
        buffer.pos(header.dosHeader.pePointer);
        header.coffHeader = CoffHeader.parse(buffer);
        if (header.coffHeader.size_of_optional_header > 0) {
            header.optionalHeader = OptionalHeader.parse(buffer);
        }
        return header;
    }

    public DosHeader getDosHeader() {
        return this.dosHeader;
    }

    public long getSignature() {
        return this.signature;
    }

    public CoffHeader getCoffHeader() {
        return this.coffHeader;
    }

    public OptionalHeader getOptionalHeader() {
        return this.optionalHeader;
    }

    public void setDosHeader(DosHeader dosHeader) {
        this.dosHeader = dosHeader;
    }

    public void setSignature(long signature) {
        this.signature = signature;
    }

    public void setCoffHeader(CoffHeader coffHeader) {
        this.coffHeader = coffHeader;
    }

    public void setOptionalHeader(OptionalHeader optionalHeader) {
        this.optionalHeader = optionalHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header other = (Header)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSignature() != other.getSignature()) {
            return false;
        }
        DosHeader this$dosHeader = this.getDosHeader();
        DosHeader other$dosHeader = other.getDosHeader();
        if (this$dosHeader == null ? other$dosHeader != null : !this$dosHeader.equals(other$dosHeader)) {
            return false;
        }
        CoffHeader this$coffHeader = this.getCoffHeader();
        CoffHeader other$coffHeader = other.getCoffHeader();
        if (this$coffHeader == null ? other$coffHeader != null : !((Object)this$coffHeader).equals(other$coffHeader)) {
            return false;
        }
        OptionalHeader this$optionalHeader = this.getOptionalHeader();
        OptionalHeader other$optionalHeader = other.getOptionalHeader();
        return !(this$optionalHeader == null ? other$optionalHeader != null : !((Object)this$optionalHeader).equals(other$optionalHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Header;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $signature = this.getSignature();
        result = result * 59 + (int)($signature >>> 32 ^ $signature);
        DosHeader $dosHeader = this.getDosHeader();
        result = result * 59 + ($dosHeader == null ? 43 : $dosHeader.hashCode());
        CoffHeader $coffHeader = this.getCoffHeader();
        result = result * 59 + ($coffHeader == null ? 43 : ((Object)$coffHeader).hashCode());
        OptionalHeader $optionalHeader = this.getOptionalHeader();
        result = result * 59 + ($optionalHeader == null ? 43 : ((Object)$optionalHeader).hashCode());
        return result;
    }

    public String toString() {
        return "Header(dosHeader=" + this.getDosHeader() + ", signature=" + this.getSignature() + ", coffHeader=" + this.getCoffHeader() + ", optionalHeader=" + this.getOptionalHeader() + ")";
    }
}

