/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe.header;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.Section;

public class CoffHeader {
    int machine;
    int number_of_sections;
    long timeDateStamp;
    long pointer_to_symbol_table;
    long number_of_symbol_table;
    int size_of_optional_header;
    int characteristics;

    public static CoffHeader parse(ParseBuffer buffer) {
        CoffHeader coffHeader = new CoffHeader();
        long signature = buffer.readU32();
        coffHeader.machine = buffer.readU16();
        coffHeader.number_of_sections = buffer.readU16();
        coffHeader.timeDateStamp = buffer.readU32();
        coffHeader.pointer_to_symbol_table = buffer.readU32();
        coffHeader.number_of_symbol_table = buffer.readU32();
        coffHeader.size_of_optional_header = buffer.readU16();
        coffHeader.characteristics = buffer.readU16();
        return coffHeader;
    }

    public Section[] parseSection(ParseBuffer parseBuffer, long offset) {
        Section[] sections = new Section[this.number_of_sections];
        if (parseBuffer.len() / 40L < (long)this.number_of_sections) {
            return null;
        }
        parseBuffer.pos(offset);
        for (int i = 0; i < this.number_of_sections; ++i) {
            sections[i] = Section.parse(parseBuffer);
        }
        return sections;
    }

    public int getMachine() {
        return this.machine;
    }

    public int getNumber_of_sections() {
        return this.number_of_sections;
    }

    public long getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public long getPointer_to_symbol_table() {
        return this.pointer_to_symbol_table;
    }

    public long getNumber_of_symbol_table() {
        return this.number_of_symbol_table;
    }

    public int getSize_of_optional_header() {
        return this.size_of_optional_header;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    public void setMachine(int machine) {
        this.machine = machine;
    }

    public void setNumber_of_sections(int number_of_sections) {
        this.number_of_sections = number_of_sections;
    }

    public void setTimeDateStamp(long timeDateStamp) {
        this.timeDateStamp = timeDateStamp;
    }

    public void setPointer_to_symbol_table(long pointer_to_symbol_table) {
        this.pointer_to_symbol_table = pointer_to_symbol_table;
    }

    public void setNumber_of_symbol_table(long number_of_symbol_table) {
        this.number_of_symbol_table = number_of_symbol_table;
    }

    public void setSize_of_optional_header(int size_of_optional_header) {
        this.size_of_optional_header = size_of_optional_header;
    }

    public void setCharacteristics(int characteristics) {
        this.characteristics = characteristics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoffHeader)) {
            return false;
        }
        CoffHeader other = (CoffHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMachine() != other.getMachine()) {
            return false;
        }
        if (this.getNumber_of_sections() != other.getNumber_of_sections()) {
            return false;
        }
        if (this.getTimeDateStamp() != other.getTimeDateStamp()) {
            return false;
        }
        if (this.getPointer_to_symbol_table() != other.getPointer_to_symbol_table()) {
            return false;
        }
        if (this.getNumber_of_symbol_table() != other.getNumber_of_symbol_table()) {
            return false;
        }
        if (this.getSize_of_optional_header() != other.getSize_of_optional_header()) {
            return false;
        }
        return this.getCharacteristics() == other.getCharacteristics();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoffHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMachine();
        result = result * 59 + this.getNumber_of_sections();
        long $timeDateStamp = this.getTimeDateStamp();
        result = result * 59 + (int)($timeDateStamp >>> 32 ^ $timeDateStamp);
        long $pointer_to_symbol_table = this.getPointer_to_symbol_table();
        result = result * 59 + (int)($pointer_to_symbol_table >>> 32 ^ $pointer_to_symbol_table);
        long $number_of_symbol_table = this.getNumber_of_symbol_table();
        result = result * 59 + (int)($number_of_symbol_table >>> 32 ^ $number_of_symbol_table);
        result = result * 59 + this.getSize_of_optional_header();
        result = result * 59 + this.getCharacteristics();
        return result;
    }

    public String toString() {
        return "CoffHeader(machine=" + this.getMachine() + ", number_of_sections=" + this.getNumber_of_sections() + ", timeDateStamp=" + this.getTimeDateStamp() + ", pointer_to_symbol_table=" + this.getPointer_to_symbol_table() + ", number_of_symbol_table=" + this.getNumber_of_symbol_table() + ", size_of_optional_header=" + this.getSize_of_optional_header() + ", characteristics=" + this.getCharacteristics() + ")";
    }
}

