/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.RuntimeFunction;
import com.uqm.crashsight.symtabtool.pe.UnwindCode;

public class UnwindInfo {
    public byte version;
    public byte size_of_prolog;
    public byte frame_register;
    public int frame_register_offset;
    public RuntimeFunction chained_info;
    public byte[] code_bytes;

    public void parse(ParseBuffer parseBuffer, long offset) {
        parseBuffer.pos(offset);
        byte version_flags = parseBuffer.readBytes(1L)[0];
        this.version = (byte)(version_flags & 7);
        byte flags = (byte)(version_flags >> 3 & 0x1F);
        if (this.version < 1 || this.version > 2) {
            return;
        }
        this.size_of_prolog = parseBuffer.readBytes(1L)[0];
        byte count_of_codes = parseBuffer.readBytes(1L)[0];
        byte frame_info = parseBuffer.readBytes(1L)[0];
        this.frame_register = (byte)(frame_info & 0xF);
        this.frame_register_offset = (frame_info >> 4 & 0xF) * 16;
        int codes_size = (count_of_codes & 0xFF) * 2;
        this.code_bytes = new byte[codes_size];
        for (int i = 0; i < codes_size; ++i) {
            this.code_bytes[i] = parseBuffer.readBytes(1L)[0];
        }
        if (count_of_codes % 2 != 0) {
            offset += 2L;
        }
        this.chained_info = null;
        if ((flags & 4) != 0) {
            this.chained_info = new RuntimeFunction();
            byte v1 = parseBuffer.readBytes(1L)[0];
            byte v2 = parseBuffer.readBytes(1L)[0];
            byte v3 = parseBuffer.readBytes(1L)[0];
            byte v4 = parseBuffer.readBytes(1L)[0];
            this.chained_info.beginAddr = (v1 & 0xFF) + (v2 & 0xFF) * 256 + (v3 & 0xFF) * 256 * 256 + (v4 & 0xFF) * 256 * 256 * 256;
            v1 = parseBuffer.readBytes(1L)[0];
            v2 = parseBuffer.readBytes(1L)[0];
            v3 = parseBuffer.readBytes(1L)[0];
            v4 = parseBuffer.readBytes(1L)[0];
            this.chained_info.endAddr = (v1 & 0xFF) + (v2 & 0xFF) * 256 + (v3 & 0xFF) * 256 * 256 + (v4 & 0xFF) * 256 * 256 * 256;
            v1 = parseBuffer.readBytes(1L)[0];
            v2 = parseBuffer.readBytes(1L)[0];
            v3 = parseBuffer.readBytes(1L)[0];
            v4 = parseBuffer.readBytes(1L)[0];
            this.chained_info.unwind_info_addr = (v1 & 0xFF) + (v2 & 0xFF) * 256 + (v3 & 0xFF) * 256 * 256 + (v4 & 0xFF) * 256 * 256 * 256;
        }
    }

    public void parse(byte[] bytes, int offset) {
        byte version_flags = bytes[offset++];
        this.version = (byte)(version_flags & 7);
        byte flags = (byte)(version_flags >> 3 & 0x1F);
        if (this.version < 1 || this.version > 2) {
            return;
        }
        this.size_of_prolog = bytes[offset++];
        byte count_of_codes = bytes[offset++];
        byte frame_info = bytes[offset++];
        this.frame_register = (byte)(frame_info & 0xF);
        this.frame_register_offset = (frame_info >> 4 & 0xF) * 16;
        int codes_size = (count_of_codes & 0xFF) * 2;
        this.code_bytes = new byte[codes_size];
        for (int i = 0; i < codes_size; ++i) {
            this.code_bytes[i] = bytes[offset++];
        }
        if (count_of_codes % 2 != 0) {
            offset += 2;
        }
        this.chained_info = null;
        if ((flags & 4) != 0) {
            this.chained_info = new RuntimeFunction();
            byte v1 = bytes[offset++];
            byte v2 = bytes[offset++];
            byte v3 = bytes[offset++];
            byte v4 = bytes[offset++];
            this.chained_info.beginAddr = (v1 & 0xFF) + (v2 & 0xFF) * 256 + (v3 & 0xFF) * 256 * 256 + (v4 & 0xFF) * 256 * 256 * 256;
            v1 = bytes[offset++];
            v2 = bytes[offset++];
            v3 = bytes[offset++];
            v4 = bytes[offset++];
            this.chained_info.endAddr = (v1 & 0xFF) + (v2 & 0xFF) * 256 + (v3 & 0xFF) * 256 * 256 + (v4 & 0xFF) * 256 * 256 * 256;
            v1 = bytes[offset++];
            v2 = bytes[offset++];
            v3 = bytes[offset++];
            v4 = bytes[offset];
            this.chained_info.unwind_info_addr = (v1 & 0xFF) + (v2 & 0xFF) * 256 + (v3 & 0xFF) * 256 * 256 + (v4 & 0xFF) * 256 * 256 * 256;
        }
    }

    public String getFrameRegisterName() {
        return UnwindCode.getName(this.frame_register);
    }
}

