/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pe.StackFrameOffset;
import com.uqm.crashsight.symtabtool.pe.UnwindOperation;

public class UnwindCode {
    public byte code_offset;
    public UnwindOperation operation;
    public int offset;
    public byte Register;
    public StackFrameOffset sfo;
    public boolean is_error;

    public int parse(byte[] code_bytes, int i, byte frame_register) {
        this.code_offset = code_bytes[i++];
        byte operation_code = (byte)(code_bytes[i] & 0xF);
        byte operation_info = (byte)(code_bytes[i++] >> 4 & 0xF);
        switch (operation_code) {
            case 0: {
                this.Register = operation_info;
                this.operation = UnwindOperation.PushNonVolatile;
                break;
            }
            case 1: {
                this.operation = UnwindOperation.Alloc;
                if (operation_info == 0) {
                    i = this.WORD_read(code_bytes, i);
                    break;
                }
                if (operation_info != 1) break;
                i = this.DW_read(code_bytes, i);
                break;
            }
            case 2: {
                this.operation = UnwindOperation.Alloc;
                this.offset = operation_info * 8 + 8;
                break;
            }
            case 3: {
                this.operation = UnwindOperation.SetFPRegister;
                break;
            }
            case 4: {
                this.operation = UnwindOperation.SaveNonVolatile;
                this.Register = operation_info;
                i = this.WORD_read(code_bytes, i);
                if (frame_register == 0) {
                    this.sfo = StackFrameOffset.RSP;
                    break;
                }
                this.sfo = StackFrameOffset.FP;
                break;
            }
            case 5: {
                this.operation = UnwindOperation.SaveNonVolatile;
                this.Register = operation_info;
                i = this.DW_read(code_bytes, i);
                if (frame_register == 0) {
                    this.sfo = StackFrameOffset.RSP;
                    break;
                }
                this.sfo = StackFrameOffset.FP;
                break;
            }
            case 6: {
                this.operation = UnwindOperation.Noop;
                i += 2;
                break;
            }
            case 7: {
                this.operation = UnwindOperation.Noop;
                i += 4;
                break;
            }
            case 8: {
                this.operation = UnwindOperation.Noop;
                i += 2;
                break;
            }
            case 9: {
                this.operation = UnwindOperation.Noop;
                i += 4;
                break;
            }
            case 10: {
                this.operation = UnwindOperation.PushMachineFrame;
                if (operation_info == 0) {
                    this.is_error = false;
                    break;
                }
                if (operation_info != 1) break;
                this.is_error = true;
                break;
            }
            default: {
                this.operation = UnwindOperation.Noop;
            }
        }
        return i;
    }

    private int WORD_read(byte[] code_bytes, int i) {
        byte b1 = code_bytes[i++];
        byte b2 = code_bytes[i++];
        this.offset = ((b1 & 0xFF) + (b2 & 0xFF) * 256) * 8;
        return i;
    }

    private int DW_read(byte[] code_bytes, int i) {
        byte b1 = code_bytes[i++];
        byte b2 = code_bytes[i++];
        byte b3 = code_bytes[i++];
        byte b4 = code_bytes[i++];
        this.offset = (b1 & 0xFF) + (b2 & 0xFF) * 256 + (b3 & 0xFF) * 256 * 256 + (b4 & 0xFF) * 256 * 256 * 256;
        return i;
    }

    public String getRegisterName() {
        return UnwindCode.getName(this.Register);
    }

    static String getName(byte register) {
        switch (register) {
            case 0: {
                return "$rax";
            }
            case 1: {
                return "$rcx";
            }
            case 2: {
                return "$rdx";
            }
            case 3: {
                return "$rbx";
            }
            case 4: {
                return "$rsp";
            }
            case 5: {
                return "$rbp";
            }
            case 6: {
                return "$rsi";
            }
            case 7: {
                return "$rdi";
            }
            case 8: {
                return "$r8";
            }
            case 9: {
                return "$r9";
            }
            case 10: {
                return "$r10";
            }
            case 11: {
                return "$r11";
            }
            case 12: {
                return "$r12";
            }
            case 13: {
                return "$r13";
            }
            case 14: {
                return "$r14";
            }
            case 15: {
                return "$r15";
            }
            case 16: {
                return "$rip";
            }
            case 17: {
                return "$xmm0";
            }
            case 18: {
                return "$xmm1";
            }
            case 19: {
                return "$xmm2";
            }
            case 20: {
                return "$xmm3";
            }
            case 21: {
                return "$xmm4";
            }
            case 22: {
                return "$xmm5";
            }
            case 23: {
                return "$xmm6";
            }
            case 24: {
                return "$xmm7";
            }
            case 25: {
                return "$xmm8";
            }
            case 26: {
                return "$xmm9";
            }
            case 27: {
                return "$xmm10";
            }
            case 28: {
                return "$xmm11";
            }
            case 29: {
                return "$xmm12";
            }
            case 30: {
                return "$xmm13";
            }
            case 31: {
                return "$xmm14";
            }
            case 32: {
                return "$xmm15";
            }
        }
        return "";
    }
}

