/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class Section {
    byte[] name;
    char[] nameChar = new char[8];
    long virtualSize;
    public long virtualAddress;
    long sizeOfRawData;
    public long pointerToRawData;
    long pointerToRelocations;
    long pointerToLineNumbers;
    int numberOfRelocations;
    int numberOfLineNumbers;
    long characteristics;
    public static final long SIZEOF_SECTION = 24L;

    public boolean is_in_section(long rva, long file_alignment) {
        return rva >= this.virtualAddress && rva < this.virtualAddress + this.section_read_size(file_alignment);
    }

    private long section_read_size(long file_alignment) {
        long read_size = (this.pointerToRawData + this.sizeOfRawData + file_alignment - 1L & -file_alignment) - (this.pointerToRawData & 0xFFFFFFFFFFFFFE00L);
        read_size = Math.min(read_size, this.sizeOfRawData + 4095L & 0xFFFFFFFFFFFFF000L);
        if (this.virtualSize == 0L) {
            return read_size;
        }
        return Math.min(read_size, this.virtualSize + 4095L & 0xFFFFFFFFFFFFF000L);
    }

    public static Section parse(ParseBuffer parseBuffer) {
        Section section = new Section();
        section.name = parseBuffer.readBytes(8L);
        for (int i = 0; i < 8; ++i) {
            section.nameChar[i] = (char)section.name[i];
        }
        section.virtualSize = parseBuffer.readU32();
        section.virtualAddress = parseBuffer.readU32();
        section.sizeOfRawData = parseBuffer.readU32();
        section.pointerToRawData = parseBuffer.readU32();
        section.pointerToRelocations = parseBuffer.readU32();
        section.pointerToLineNumbers = parseBuffer.readU32();
        section.numberOfRelocations = parseBuffer.readU16();
        section.numberOfLineNumbers = parseBuffer.readU16();
        section.characteristics = parseBuffer.readU32();
        return section;
    }
}

