/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.common.CodeId;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.goblin.Goblin;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.pdb.Cpu;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.PE;
import com.uqm.crashsight.symtabtool.pe.RuntimeFunction;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.UnwindCode;
import com.uqm.crashsight.symtabtool.pe.UnwindInfo;
import com.uqm.crashsight.symtabtool.pe.header.DataDirectories;
import com.uqm.crashsight.symtabtool.pe.header.Header;
import com.uqm.crashsight.symtabtool.pe.header.OptionalHeader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Stack;

public class PeObject {
    public PE pe;
    ParseBuffer buffer;
    boolean isStub;
    public String peFileName = "";
    Cpu cpu;
    String debugId = "";
    String codeId;
    String stack;
    public String symbolPath = "";
    String peName = "";
    public String appName = "";

    public PeObject(String fileName, String fileType) {
        String peName;
        this.peName = Paths.get(fileName, new String[0]).getFileName().toString();
        File file = null;
        long fileSize = 0L;
        if (fileType.equals("PDB") ? (fileSize = (file = new File(peName = fileName.substring(0, fileName.length() - 4) + ".exe")).length()) == 0L && (fileSize = (file = new File(peName = fileName.substring(0, fileName.length() - 4) + ".dll")).length()) == 0L : (fileSize = (file = new File(fileName)).length()) == 0L) {
            return;
        }
        byte[] oriBuffer = new byte[(int)fileSize];
        try {
            int numRead;
            FileInputStream fi = new FileInputStream(file);
            for (int offset = 0; offset < oriBuffer.length && (numRead = fi.read(oriBuffer, offset, oriBuffer.length - offset)) >= 0; offset += numRead) {
            }
            fi.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.buffer = new ParseBuffer(oriBuffer);
        this.pe = PE.parse(this.buffer);
        this.appName = this.peName.substring(0, this.peName.lastIndexOf(46));
        this.peFileName = fileName;
        this.debugId = this.pe.getDebugId();
    }

    public static boolean isPeStub(PE pe) {
        return true;
    }

    public boolean test(ParseBuffer buffer) {
        return Goblin.peek(buffer).getPe();
    }

    public static PeObject parse(ParseBuffer buffer) {
        PeObject self = new PeObject("", "");
        return self;
    }

    public String processCfi() {
        RuntimeFunction[] functions;
        StringBuilder stackCfi = new StringBuilder();
        StringBuilder cfa_reg = new StringBuilder();
        StringBuilder saved_regs = new StringBuilder();
        Stack<UnwindCode> codes = new Stack<UnwindCode>();
        DataDirectories.DataDirectory dataDirectory = this.pe.getHeader().getOptionalHeader().getDataDirectories().getExceptionTable();
        Section[] sections = this.pe.sections;
        if (this.pe.exceptionData == null) {
            Log.error("Exception data is missing.", new Object[0]);
            return null;
        }
        for (RuntimeFunction func : functions = this.pe.exceptionData.findFunctions(this.buffer)) {
            if (func.beginAddr == 0L && func.endAddr == 0L && func.unwind_info_addr == 0L || func.beginAddr > func.endAddr) continue;
            int stack_size = 8;
            int machine_frame_offset = 0;
            cfa_reg.delete(0, cfa_reg.length());
            saved_regs.delete(0, saved_regs.length());
            RuntimeFunction next_function = func;
            int count = 0;
            while (next_function != null) {
                int i;
                ++count;
                UnwindInfo unwind_info = new UnwindInfo();
                for (i = 0; i < sections.length; ++i) {
                    if (!sections[i].is_in_section(next_function.unwind_info_addr, this.pe.fileAlignment)) continue;
                    long UnwindInfoOffset = next_function.unwind_info_addr - sections[i].virtualAddress + (sections[i].pointerToRawData & 0xFFFFFFFFFFFFFE00L);
                    unwind_info.parse(this.buffer, UnwindInfoOffset);
                    break;
                }
                if (unwind_info == null || unwind_info.code_bytes == null) {
                    next_function = null;
                    continue;
                }
                i = 0;
                while (i < unwind_info.code_bytes.length) {
                    UnwindCode code = new UnwindCode();
                    i = code.parse(unwind_info.code_bytes, i, unwind_info.frame_register);
                    codes.push(code);
                }
                while (!codes.empty()) {
                    UnwindCode code = (UnwindCode)codes.peek();
                    switch (code.operation) {
                        case SaveNonVolatile: {
                            break;
                        }
                        case PushNonVolatile: {
                            stack_size += 8;
                            break;
                        }
                        case Alloc: {
                            stack_size += code.offset;
                            break;
                        }
                        case SetFPRegister: {
                            int off = stack_size - unwind_info.frame_register_offset;
                            break;
                        }
                        case PushMachineFrame: {
                            int rsp_offset = stack_size + 16;
                            int rip_offset = stack_size + 40;
                            saved_regs.append(" $rsp: .cfa ").append(rsp_offset).append(" - ^ .ra: .cfa ").append(rip_offset).append(" - ^");
                            machine_frame_offset = stack_size += 40;
                            if (!code.is_error) break;
                            stack_size += 8;
                            break;
                        }
                    }
                    codes.pop();
                }
                next_function = unwind_info.chained_info;
            }
            if (cfa_reg.length() == 0) {
                cfa_reg.append(".cfa: $rsp ").append(stack_size).append(" +");
            }
            if (machine_frame_offset == 0) {
                saved_regs.append(".cfa: $rsp .ra: .cfa 8 - ^");
            }
            stackCfi.append("STACK CFI INIT ").append(Long.toHexString(func.beginAddr)).append(" ").append(Long.toHexString(func.endAddr - func.beginAddr)).append(" ");
            stackCfi.append((CharSequence)saved_regs);
            stackCfi.append("\n");
            stackCfi.append("STACK CFI ").append(Long.toHexString(func.beginAddr)).append(" ").append((CharSequence)cfa_reg);
            stackCfi.append("\n");
        }
        return stackCfi.toString();
    }

    public String getDebugId() {
        return this.debugId;
    }

    public CodeId getCodeId() {
        Header header = this.pe.getHeader();
        OptionalHeader optionalHeader = header.getOptionalHeader();
        long timestamp = header.getCoffHeader().getTimeDateStamp();
        long sizeOfImage = optionalHeader.getWindowsFields().getSizeOfImage();
        String str = String.format("%x%x", timestamp, sizeOfImage);
        return new CodeId(str);
    }

    public String getArch() {
        return this.cpu.toString();
    }

    public boolean load() {
        try {
            Log.info("Begin to parse file: %s", this.peFileName);
            this.cpu = this.pe.getCpu();
            if (this.cpu.name().equals("X86")) {
                Log.error("X86 is not supported.", new Object[0]);
                return false;
            }
            this.codeId = this.getCodeId().getInner();
            this.debugId = this.pe.getDebugId();
            if (this.debugId == "") {
                return false;
            }
            this.stack = this.processCfi();
            if (this.stack == null) {
                return false;
            }
            this.symbolPath = this.peSymtabFileNameFormatter();
            BufferedWriter bufferedWriter = FileHelper.openFileWriter(new File(this.symbolPath));
            this.display(bufferedWriter);
            assert (bufferedWriter != null);
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public void display(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(String.format("MODULE windows %s %s %s\n", new Object[]{this.cpu, this.debugId, this.peName}));
            if (this.codeId != null && !this.codeId.isEmpty()) {
                bufferedWriter.write(String.format("INFO CODE_ID %s %s\n", this.codeId, this.peName));
            }
            bufferedWriter.write(String.format("%s\n", this.stack));
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    private String peSymtabFileNameFormatter() {
        String peDir = Paths.get(this.peFileName, new String[0]).getParent().toString();
        this.appName = this.peName.substring(0, this.peName.lastIndexOf(46));
        String pdbSymtabFileName = "crashsightSymbol";
        pdbSymtabFileName = pdbSymtabFileName + "&";
        pdbSymtabFileName = pdbSymtabFileName + this.getArch();
        pdbSymtabFileName = pdbSymtabFileName + "&";
        pdbSymtabFileName = pdbSymtabFileName + Utils.urlEncodeString(this.appName);
        pdbSymtabFileName = pdbSymtabFileName + "&";
        pdbSymtabFileName = pdbSymtabFileName + this.debugId;
        pdbSymtabFileName = pdbSymtabFileName + ".sym";
        return Paths.get(peDir, pdbSymtabFileName).toString();
    }
}

