/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pdb.Cpu;
import com.uqm.crashsight.symtabtool.pdb.dbi.MachineType;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.DebugData;
import com.uqm.crashsight.symtabtool.pe.ExceptionData;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.header.Header;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;

public class PE {
    public Header header;
    public Section[] sections;
    public DebugData debugData;
    public ExceptionData exceptionData;
    public long fileAlignment;

    public static PE parse(ParseBuffer buffer) {
        return PE.parseWithOpts(buffer, true);
    }

    public static PE parseWithOpts(ParseBuffer buffer, boolean parseOption) {
        PE pe = new PE();
        pe.header = Header.parse(buffer);
        long offset = pe.header.getDosHeader().pePointer + 4L + 20L + (long)pe.header.getCoffHeader().getSize_of_optional_header();
        pe.fileAlignment = pe.header.getOptionalHeader().getWindowsFields().getFile_alignment();
        pe.sections = pe.header.getCoffHeader().parseSection(buffer, offset);
        pe.debugData = DebugData.parse(buffer, pe.header.getOptionalHeader().getDataDirectories().getDebugTable(), pe.sections, pe.fileAlignment);
        if ((long)pe.header.getCoffHeader().getMachine() == 34404L) {
            pe.exceptionData = ExceptionData.parse(buffer, pe.header.getOptionalHeader().getDataDirectories().getExceptionTable(), pe.sections, pe.fileAlignment);
        }
        return pe;
    }

    public Cpu getCpu() {
        MachineType mt = MachineType.fromInt(this.header.getCoffHeader().getMachine());
        switch (mt) {
            case X86: {
                return Cpu.X86;
            }
            case Amd64: 
            case Ia64: {
                return Cpu.X86_64;
            }
        }
        return Cpu.Unknown;
    }

    public String getDebugId() {
        if (this.debugData != null && this.debugData.codeviewPDB70DebugInfo.signature != null) {
            String uuidStr = Hex.encodeHexString(this.debugData.codeviewPDB70DebugInfo.signature.getBytes()).toUpperCase();
            StringBuilder sb = new StringBuilder();
            sb.append(uuidStr);
            sb.append(Long.toHexString(this.debugData.codeviewPDB70DebugInfo.age));
            return sb.toString().toUpperCase();
        }
        return "";
    }

    public Header getHeader() {
        return this.header;
    }

    public Section[] getSections() {
        return this.sections;
    }

    public DebugData getDebugData() {
        return this.debugData;
    }

    public ExceptionData getExceptionData() {
        return this.exceptionData;
    }

    public long getFileAlignment() {
        return this.fileAlignment;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setSections(Section[] sections) {
        this.sections = sections;
    }

    public void setDebugData(DebugData debugData) {
        this.debugData = debugData;
    }

    public void setExceptionData(ExceptionData exceptionData) {
        this.exceptionData = exceptionData;
    }

    public void setFileAlignment(long fileAlignment) {
        this.fileAlignment = fileAlignment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PE)) {
            return false;
        }
        PE other = (PE)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFileAlignment() != other.getFileAlignment()) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSections(), other.getSections())) {
            return false;
        }
        DebugData this$debugData = this.getDebugData();
        DebugData other$debugData = other.getDebugData();
        if (this$debugData == null ? other$debugData != null : !this$debugData.equals(other$debugData)) {
            return false;
        }
        ExceptionData this$exceptionData = this.getExceptionData();
        ExceptionData other$exceptionData = other.getExceptionData();
        return !(this$exceptionData == null ? other$exceptionData != null : !this$exceptionData.equals(other$exceptionData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PE;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fileAlignment = this.getFileAlignment();
        result = result * 59 + (int)($fileAlignment >>> 32 ^ $fileAlignment);
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSections());
        DebugData $debugData = this.getDebugData();
        result = result * 59 + ($debugData == null ? 43 : $debugData.hashCode());
        ExceptionData $exceptionData = this.getExceptionData();
        result = result * 59 + ($exceptionData == null ? 43 : $exceptionData.hashCode());
        return result;
    }

    public String toString() {
        return "PE(header=" + this.getHeader() + ", sections=" + Arrays.deepToString(this.getSections()) + ", debugData=" + this.getDebugData() + ", exceptionData=" + this.getExceptionData() + ", fileAlignment=" + this.getFileAlignment() + ")";
    }
}

