/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.RuntimeFunction;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.header.DataDirectories;

public class ExceptionData {
    byte a;
    long offset;
    long size;
    long fileAlignment;
    private static final long RUNTIME_FUNCTION_SIZE = 12L;

    public static ExceptionData parse(ParseBuffer parseBuffer, DataDirectories.DataDirectory dataDirectory, Section[] sections, long fileAlignment) {
        ExceptionData exceptionData = new ExceptionData();
        exceptionData.size = dataDirectory.size;
        if (exceptionData.size % 12L != 0L) {
            return null;
        }
        long rva = dataDirectory.virtualAddress;
        exceptionData.offset = Utils.findOffset(rva, sections, fileAlignment);
        if (exceptionData.offset % 4L != 0L) {
            return null;
        }
        return exceptionData;
    }

    public RuntimeFunction[] findFunctions(ParseBuffer parseBuffer) {
        int functionNumber = new Long(this.size).intValue() / new Long(12L).intValue();
        RuntimeFunction[] functions = new RuntimeFunction[functionNumber];
        parseBuffer.pos(this.offset);
        for (int i = 0; i < functionNumber; ++i) {
            functions[i] = new RuntimeFunction();
            functions[i].beginAddr = parseBuffer.readU32();
            functions[i].endAddr = parseBuffer.readU32();
            functions[i].unwind_info_addr = parseBuffer.readU32();
        }
        return functions;
    }
}

