/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pdb.pdbi.Uuid;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.header.DataDirectories;

public class DebugData {
    ImageDebugDirectory imageDebugDirectory = new ImageDebugDirectory();
    CodeviewPDB70DebugInfo codeviewPDB70DebugInfo = new CodeviewPDB70DebugInfo();
    private static final long IMAGE_DEBUG_TYPE_CODEVIEW = 2L;

    public static DebugData parse(ParseBuffer parseBuffer, DataDirectories.DataDirectory dataDirectory, Section[] secions, long fileAlignment) {
        DebugData debugData = new DebugData();
        debugData.imageDebugDirectory.parse(parseBuffer, dataDirectory.virtualAddress, fileAlignment, secions);
        debugData.codeviewPDB70DebugInfo.parse(parseBuffer, debugData.imageDebugDirectory);
        return debugData;
    }

    public class CodeviewPDB70DebugInfo {
        long codeviewSignature;
        Uuid signature;
        long age;
        byte[] fileName;
        char[] fileNameChar = new char[8];
        private static final long CODEVIEW_PDB70_MAGIC = 1396986706L;

        public boolean parse(ParseBuffer parseBuffer, ImageDebugDirectory imageDebugDirectory) {
            if (imageDebugDirectory.dataType != 2L) {
                return false;
            }
            long offset = imageDebugDirectory.pointerToRawData;
            long fileNameLength = imageDebugDirectory.sizeOfData - 24L;
            if (fileNameLength < 0L) {
                return false;
            }
            parseBuffer.pos(offset);
            this.codeviewSignature = parseBuffer.readU32();
            if (this.codeviewSignature != 1396986706L) {
                return false;
            }
            this.signature = Uuid.parse(parseBuffer);
            this.age = parseBuffer.readU32();
            this.fileName = parseBuffer.readBytes(fileNameLength);
            this.fileNameChar = new char[new Long(fileNameLength).intValue()];
            int i = 0;
            while ((long)i < fileNameLength) {
                this.fileNameChar[i] = (char)this.fileName[i];
                ++i;
            }
            return true;
        }
    }

    public class ImageDebugDirectory {
        long characteriestics;
        long timeDateStamp;
        int majorVersion;
        int minorVersion;
        long dataType;
        long sizeOfData;
        long addressOfRawData;
        long pointerToRawData;

        public boolean parse(ParseBuffer parseBuffer, long rva, long fileAlign, Section[] sections) {
            int PHYSICAL_ALIGN = 511;
            int PAGE_MASK = 4095;
            long offset = -1L;
            for (int i = 0; i < sections.length; ++i) {
                if (!sections[i].is_in_section(rva, fileAlign)) continue;
                offset = rva - sections[i].virtualAddress + (sections[i].pointerToRawData & (long)(~PHYSICAL_ALIGN));
                break;
            }
            if (offset == -1L) {
                return false;
            }
            parseBuffer.pos(offset);
            this.characteriestics = parseBuffer.readU32();
            this.timeDateStamp = parseBuffer.readU32();
            this.majorVersion = parseBuffer.readU16();
            this.minorVersion = parseBuffer.readU16();
            this.dataType = parseBuffer.readU32();
            this.sizeOfData = parseBuffer.readU32();
            this.addressOfRawData = parseBuffer.readU32();
            this.pointerToRawData = parseBuffer.readU32();
            return true;
        }
    }
}

