/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.types;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.common.Variant;
import com.uqm.crashsight.symtabtool.pdb.common.VariantEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.ArgumentList;
import com.uqm.crashsight.symtabtool.pdb.tpi.ArrayType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ClassKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.ClassType;
import com.uqm.crashsight.symtabtool.pdb.tpi.EnumerateType;
import com.uqm.crashsight.symtabtool.pdb.tpi.EnumerationType;
import com.uqm.crashsight.symtabtool.pdb.tpi.Item;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemFinder;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemInformation;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemIter;
import com.uqm.crashsight.symtabtool.pdb.tpi.MemberFunctionType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ModifierType;
import com.uqm.crashsight.symtabtool.pdb.tpi.PFunctionAttributes;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerMode;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerType;
import com.uqm.crashsight.symtabtool.pdb.tpi.PrimitiveKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.PrimitiveType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ProcedureType;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeData;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeInterface;
import com.uqm.crashsight.symtabtool.pdb.tpi.UnionType;
import com.uqm.crashsight.symtabtool.pdb.types.DemangleOptions;
import com.uqm.crashsight.symtabtool.pdb.types.DumperFlags;
import com.uqm.crashsight.symtabtool.pdb.types.Language;
import com.uqm.crashsight.symtabtool.pdb.types.Name;
import com.uqm.crashsight.symtabtool.pdb.types.NameMangling;
import com.uqm.crashsight.symtabtool.pdb.types.PFuncName;
import com.uqm.crashsight.symtabtool.pdb.types.PtrAttributes;
import com.uqm.crashsight.symtabtool.pdb.types.Quaternion;
import com.uqm.crashsight.symtabtool.pdb.types.ThisKind;
import com.uqm.crashsight.symtabtool.pdb.types.Undecorated;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TypeDumper {
    ItemFinder finder;
    Map<String, Long> fwd;
    long ptrSize;
    DumperFlags flags;

    public TypeDumper(ItemInformation typeInfo, long ptrSize, DumperFlags flags) {
        Item typ;
        ItemIter types = typeInfo.iter();
        ItemFinder finder = typeInfo.finder();
        this.fwd = new LinkedHashMap<String, Long>();
        while ((typ = types.next()) != null) {
            String name;
            TypeInterface t;
            finder.update(types);
            TypeData typeData = typ.parse();
            if (typeData.get((Object)TypeEnum.Class) != null) {
                t = (ClassType)typeData.get((Object)TypeEnum.Class);
                if (((ClassType)t).getProperties().forwardReference()) continue;
                name = ((ClassType)t).getUniqueName();
                this.fwd.put(name, Long.valueOf(((ClassType)t).getSize()));
                continue;
            }
            if (typeData.get((Object)TypeEnum.Union) == null || ((UnionType)(t = (UnionType)typeData.get((Object)TypeEnum.Union))).getProperties().forwardReference()) continue;
            name = ((UnionType)t).getUniqueName();
            this.fwd.put(name, ((UnionType)t).getSize());
        }
        this.finder = finder;
        this.ptrSize = ptrSize;
        this.flags = flags;
    }

    public TypeData find(TypeIndex index) {
        Item typ = this.finder.find(index.getIndex());
        return typ.parse();
    }

    public long getClassSize(ClassType typ) {
        if (typ.getProperties().forwardReference()) {
            String name = typ.getUniqueName();
            return this.fwd.getOrDefault(name, Long.valueOf(typ.getSize()));
        }
        return typ.getSize();
    }

    public long getUnionSize(UnionType typ) {
        if (typ.getProperties().forwardReference()) {
            String name = typ.getUniqueName();
            return this.fwd.getOrDefault(name, typ.getSize());
        }
        return typ.getSize();
    }

    public long getTypeSize(TypeIndex typeIndex) {
        TypeData typ = this.find(typeIndex);
        return this.getDataSize(typ);
    }

    public long getDataSize(TypeData typeData) {
        if (typeData.get((Object)TypeEnum.Primitive) != null) {
            PrimitiveType t = (PrimitiveType)typeData.get((Object)TypeEnum.Primitive);
            if (t.getIndirection() != null) {
                return this.ptrSize;
            }
            PrimitiveKind kind = t.getKind();
            switch (kind) {
                case NoType: 
                case Void: {
                    return 0L;
                }
                case Char: 
                case UChar: 
                case RChar: 
                case I8: 
                case U8: 
                case Bool8: {
                    return 1L;
                }
                case WChar: 
                case RChar16: 
                case Short: 
                case UShort: 
                case I16: 
                case U16: 
                case F16: 
                case Bool16: {
                    return 2L;
                }
                case RChar32: 
                case Long: 
                case ULong: 
                case I32: 
                case U32: 
                case F32: 
                case F32PP: 
                case Bool32: 
                case HRESULT: {
                    return 4L;
                }
                case I64: 
                case U64: 
                case Quad: 
                case UQuad: 
                case F64: 
                case Complex32: 
                case Bool64: {
                    return 8L;
                }
                case I128: 
                case U128: 
                case Octa: 
                case UOcta: 
                case F128: 
                case Complex64: {
                    return 16L;
                }
                case F48: {
                    return 6L;
                }
                case F80: {
                    return 10L;
                }
                case Complex80: {
                    return 20L;
                }
                case Complex128: {
                    return 32L;
                }
            }
            Log.error("Unsupported primitive type %d", new Object[]{kind});
        } else {
            if (typeData.get((Object)TypeEnum.Class) != null) {
                ClassType t = (ClassType)typeData.get((Object)TypeEnum.Class);
                return this.getClassSize(t);
            }
            if (typeData.get((Object)TypeEnum.MemberFunction) != null) {
                return this.ptrSize;
            }
            if (typeData.get((Object)TypeEnum.Procedure) != null) {
                return this.ptrSize;
            }
            if (typeData.get((Object)TypeEnum.Pointer) != null) {
                PointerType t = (PointerType)typeData.get((Object)TypeEnum.Pointer);
                return t.getAttributes().size();
            }
            if (typeData.get((Object)TypeEnum.Array) != null) {
                ArrayType t = (ArrayType)typeData.get((Object)TypeEnum.Array);
                return t.getDimensions().get(t.getDimensions().size() - 1);
            }
            if (typeData.get((Object)TypeEnum.Union) != null) {
                UnionType t = (UnionType)typeData.get((Object)TypeEnum.Union);
                return this.getUnionSize(t);
            }
            if (typeData.get((Object)TypeEnum.Enumeration) != null) {
                EnumerationType t = (EnumerationType)typeData.get((Object)TypeEnum.Enumeration);
                return this.getTypeSize(t.getUnderlyingType());
            }
            if (typeData.get((Object)TypeEnum.Enumerate) != null) {
                EnumerateType t = (EnumerateType)typeData.get((Object)TypeEnum.Enumerate);
                Variant value = t.getValue();
                if (value.get((Object)VariantEnum.I8) != null || value.get((Object)VariantEnum.U8) != null) {
                    return 1L;
                }
                if (value.get((Object)VariantEnum.I16) != null || value.get((Object)VariantEnum.U16) != null) {
                    return 2L;
                }
                if (value.get((Object)VariantEnum.I32) != null || value.get((Object)VariantEnum.U32) != null) {
                    return 4L;
                }
                if (value.get((Object)VariantEnum.I64) != null || value.get((Object)VariantEnum.U64) != null) {
                    return 8L;
                }
            } else {
                if (typeData.get((Object)TypeEnum.Modifier) != null) {
                    ModifierType t = (ModifierType)typeData.get((Object)TypeEnum.Modifier);
                    return this.getTypeSize(t.getUnderlyingType());
                }
                return 0L;
            }
        }
        return 0L;
    }

    public PFuncName dumpFunction(String name, TypeIndex index) {
        if (name == null || name.isEmpty()) {
            return new PFuncName(new Undecorated("<name omitted>"), null);
        }
        if (index.getIndex() == 0L) {
            return this.demangle(name);
        }
        TypeData typ = this.find(index);
        if (typ.containsKey((Object)TypeEnum.MemberFunction)) {
            boolean intersects = this.flags.intersects(1);
            MemberFunctionType memberFunctionType = (MemberFunctionType)typ.get((Object)TypeEnum.MemberFunction);
            Quaternion<Boolean, Boolean, String, String> q = this.dumpMethodParts(memberFunctionType, intersects);
            String ztatic = (Boolean)q.v1 != false ? "static " : "";
            String konst = (Boolean)q.v2 != false ? " const" : "";
            return new PFuncName(new Undecorated(String.format("%s%s%s(%s)%s", ztatic, this.fixReturn((String)q.v3), name, q.v4, konst)), null);
        }
        if (typ.containsKey((Object)TypeEnum.Procedure)) {
            ProcedureType t = (ProcedureType)typ.get((Object)TypeEnum.Procedure);
            Pair<String, String> p = this.dumpProcedureParts(t, this.flags.intersects(1));
            return new PFuncName(new Undecorated(String.format("%s%s(%s)", this.fixReturn(p.getKey()), name, p.getValue())), null);
        }
        Log.error("Function %s hasn't a function type", name);
        return new PFuncName(new Undecorated(name), null);
    }

    public String fixReturn(String name) {
        if (!name.isEmpty()) {
            return name + " ";
        }
        return name;
    }

    public String fixMangledName(String name) {
        return name.replace("__cdecl", "").replace("public: ", "").replace("protected: ", "").replace("private: ", "").replace("(void)", "").replace("  ", " ");
    }

    public PFuncName demangle(String ident) {
        Language lang = new Name(ident, NameMangling.Mangled, Language.Unknown).detectLanguage();
        if (lang == Language.Unknown) {
            return PFuncName.getUnknown(ident);
        }
        Name name = new Name(ident, NameMangling.Mangled, lang);
        String demangled = (name = Name.fixSymbolName(name)).demangle(DemangleOptions.complete());
        if (demangled != null) {
            if (demangled.equals(ident)) {
                return PFuncName.getUnknown(demangled);
            }
            demangled = this.fixMangledName(demangled);
            return new PFuncName(new Undecorated(demangled), null);
        }
        Log.warn("Didn't manage to demangle $s", ident);
        return new PFuncName(new Undecorated(ident), null);
    }

    public String getReturnType(TypeIndex typ, PFunctionAttributes attrs, boolean noReturn) {
        if (!noReturn && !attrs.isConstructor()) {
            String s = this.dumpIndex(typ);
            if (s != null) {
                return s;
            }
            return "";
        }
        return "";
    }

    public Pair<String, String> dumpProcedureParts(ProcedureType typ, boolean noReturn) {
        String retTyp = this.getReturnType(typ.getReturnType(), typ.getAttributes(), noReturn);
        String argsTyp = this.dumpIndex(typ.getArgumentList());
        return new Pair<String, String>(retTyp, argsTyp);
    }

    public ThisKind checkThisType(TypeIndex this_, TypeIndex class_) {
        TypeData data = this.find(this_);
        if (data.containsKey((Object)TypeEnum.Pointer)) {
            PointerType ptr = (PointerType)data.get((Object)TypeEnum.Pointer);
            if (ptr.getUnderlyingType().getIndex() == class_.getIndex()) {
                return ThisKind.This;
            }
            TypeData underlyingTyp = this.find(ptr.getUnderlyingType());
            if (underlyingTyp.containsKey((Object)TypeEnum.Modifier)) {
                ModifierType modifier = (ModifierType)underlyingTyp.get((Object)TypeEnum.Modifier);
                return ThisKind.newKind(modifier.getUnderlyingType().getIndex() == class_.getIndex(), modifier.isConstant());
            }
            return ThisKind.NotThis;
        }
        if (data.containsKey((Object)TypeEnum.Modifier)) {
            ModifierType modifier = (ModifierType)data.get((Object)TypeEnum.Modifier);
            TypeData underlyingTyp = this.find(modifier.getUnderlyingType());
            if (underlyingTyp.containsKey((Object)TypeEnum.Pointer)) {
                PointerType ptr = (PointerType)underlyingTyp.get((Object)TypeEnum.Pointer);
                return ThisKind.newKind(ptr.getUnderlyingType().getIndex() == class_.getIndex(), modifier.isConstant());
            }
            return ThisKind.NotThis;
        }
        return ThisKind.NotThis;
    }

    public Quaternion<Boolean, Boolean, String, String> dumpMethodParts(MemberFunctionType typ, Boolean noReturn) {
        String retTyp = this.getReturnType(typ.getReturnType(), typ.getAttributes(), noReturn);
        String argsTyp = this.dumpIndex(typ.getArgumentList());
        boolean ztatic = typ.getThisPointerType() == null;
        boolean constMeth = false;
        if (!ztatic) {
            TypeIndex thisTyp = typ.getThisPointerType();
            ThisKind thisKind = this.checkThisType(thisTyp, typ.getClassType());
            if (thisKind == ThisKind.NotThis) {
                String thisTypStr = this.dumpIndex(thisTyp);
                if (argsTyp.isEmpty()) {
                    argsTyp = thisTypStr;
                } else {
                    argsTyp = String.format("%s, %s", thisTypStr, argsTyp);
                    constMeth = false;
                }
            } else {
                constMeth = thisKind == ThisKind.ConstThis;
            }
        }
        return new Quaternion<Boolean, Boolean, String, String>(ztatic, constMeth, retTyp, argsTyp);
    }

    public String dumpAttributes(List<PtrAttributes> attrs) {
        StringBuilder sb = new StringBuilder();
        for (int i = attrs.size() - 1; i >= 0; --i) {
            PtrAttributes attr = attrs.get(i);
            if (attr.isPointeeConst) {
                if (this.flags.intersects(4)) {
                    sb.append(" const ");
                } else {
                    sb.append(" const");
                }
            }
            if (attr.mode == PointerMode.Pointer) {
                sb.append("*");
            } else if (attr.mode == PointerMode.LValueReference) {
                sb.append("&");
            } else if (attr.mode == PointerMode.Member) {
                sb.append("::*");
            } else if (attr.mode == PointerMode.RValueReference) {
                sb.append("&&");
            }
            if (!attr.isPointerConst) continue;
            if (this.flags.intersects(4)) {
                sb.append(" const ");
                continue;
            }
            sb.append(" const");
        }
        return sb.toString().trim();
    }

    public String dumpMemberPtr(MemberFunctionType fun, List<PtrAttributes> attributes) {
        String class_ = this.dumpIndex(fun.getClassType());
        Quaternion<Boolean, Boolean, String, String> q = this.dumpMethodParts(fun, false);
        String ret = (String)q.v3;
        String args2 = (String)q.v4;
        String attrs = this.dumpAttributes(attributes);
        return String.format("%s(%s%s)(%s)", this.fixReturn(ret), class_, attrs, args2);
    }

    public String dumpProcPtr(ProcedureType fun, List<PtrAttributes> attributes) {
        Pair<String, String> pair = this.dumpProcedureParts(fun, false);
        String ret = pair.getKey();
        String args2 = pair.getValue();
        String attrs = this.dumpAttributes(attributes);
        return String.format("%s(%s)(%s)", this.fixReturn(ret), attrs, args2);
    }

    public String dumpOtherPtr(TypeData typ, List<PtrAttributes> attributes) {
        String typStr = this.dumpData(typ);
        if (StringUtils.isEmpty(typStr) || typStr.length() == 0) {
            return "";
        }
        String attrs = this.dumpAttributes(attributes);
        char c = typStr.charAt(typStr.length() - 1);
        String space = " ";
        if (!attrs.startsWith("c") && (c == '*' || c == '&' || this.flags.intersects(4))) {
            space = "";
        }
        return String.format("%s%s%s", typStr, space, attrs);
    }

    public String dumpPtrHelper(List<PtrAttributes> attributes, TypeData typ) {
        if (typ.containsKey((Object)TypeEnum.MemberFunction)) {
            MemberFunctionType t = (MemberFunctionType)typ.get((Object)TypeEnum.MemberFunction);
            return this.dumpMemberPtr(t, attributes);
        }
        if (typ.containsKey((Object)TypeEnum.Procedure)) {
            ProcedureType t = (ProcedureType)typ.get((Object)TypeEnum.Procedure);
            return this.dumpProcPtr(t, attributes);
        }
        return this.dumpOtherPtr(typ, attributes);
    }

    public String dumpPtr(PointerType ptr, boolean isConst) {
        TypeData typ;
        ArrayList<PtrAttributes> attributes;
        block2: {
            TypeData typ1;
            PtrAttributes ptrAttributes = new PtrAttributes(ptr.getAttributes().isConst() || isConst, false, ptr.getAttributes().pointerMode());
            attributes = new ArrayList<PtrAttributes>();
            attributes.add(ptrAttributes);
            while (true) {
                TypeInterface t;
                if ((typ = this.find(ptr.getUnderlyingType())).containsKey((Object)TypeEnum.Pointer)) {
                    t = (PointerType)typ.get((Object)TypeEnum.Pointer);
                    attributes.add(new PtrAttributes(((PointerType)t).getAttributes().isConst(), false, ((PointerType)t).getAttributes().pointerMode()));
                    ptr = t;
                    continue;
                }
                if (!typ.containsKey((Object)TypeEnum.Modifier)) break block2;
                t = (ModifierType)typ.get((Object)TypeEnum.Modifier);
                ((PtrAttributes)attributes.get((int)(attributes.size() - 1))).isPointeeConst = ((ModifierType)t).isConstant();
                typ1 = this.find(((ModifierType)t).getUnderlyingType());
                if (!typ1.containsKey((Object)TypeEnum.Pointer)) break;
                PointerType pointerType = (PointerType)typ1.get((Object)TypeEnum.Pointer);
                attributes.add(new PtrAttributes(pointerType.getAttributes().isConst(), false, pointerType.getAttributes().pointerMode()));
            }
            return this.dumpPtrHelper(attributes, typ1);
        }
        return this.dumpPtrHelper(attributes, typ);
    }

    public Pair<List<Long>, TypeData> getArrayInfo(ArrayType array) {
        TypeData typ;
        ArrayType base = array;
        ArrayList<Long> dims = new ArrayList<Long>();
        dims.add(base.getDimensions().get(0));
        while ((typ = this.find(base.getElementType())).containsKey((Object)TypeEnum.Array)) {
            ArrayType a = (ArrayType)typ.get((Object)TypeEnum.Array);
            dims.add(a.getDimensions().get(0));
            base = a;
        }
        return new Pair<List<Long>, TypeData>(dims, typ);
    }

    public String dumpArray(ArrayType array) {
        Pair<List<Long>, TypeData> pa = this.getArrayInfo(array);
        List<Long> dimensions = pa.getKey();
        TypeData base = pa.getValue();
        long size = this.getDataSize(base);
        Collections.reverse(dimensions);
        long[] sizeArr = new long[]{size};
        List dims = dimensions.stream().map(dim -> {
            String s = "[]";
            if (sizeArr[0] != 0L) {
                s = String.format("[%d]", dim / sizeArr[0]);
            }
            sizeArr[0] = dim;
            return s;
        }).collect(Collectors.toList());
        Collections.reverse(dims);
        String baseTyp = this.dumpData(base);
        return String.format("%s%s", baseTyp, StringUtils.join(dims, ""));
    }

    public String dumpModifier(ModifierType modifier) {
        TypeData typ = this.find(modifier.getUnderlyingType());
        if (typ.containsKey((Object)TypeEnum.Pointer)) {
            PointerType ptr = (PointerType)typ.get((Object)TypeEnum.Pointer);
            return this.dumpPtr(ptr, modifier.isConstant());
        }
        if (typ.containsKey((Object)TypeEnum.Primitive)) {
            PrimitiveType prim = (PrimitiveType)typ.get((Object)TypeEnum.Primitive);
            return this.dumpPrimitive(prim, modifier.isConstant());
        }
        String underlyingTyp = this.dumpData(typ);
        if (modifier.isConstant()) {
            return String.format("const %s", underlyingTyp);
        }
        return underlyingTyp;
    }

    public String dumpClass(ClassType classType) {
        if (this.flags.intersects(8)) {
            return classType.getName();
        }
        String name = classType.getName();
        ClassKind kind = classType.getKind();
        if (kind == ClassKind.Class) {
            name = "class";
        } else if (kind == ClassKind.Interface) {
            name = "interface";
        } else if (kind == ClassKind.Struct) {
            name = "struct";
        } else {
            Log.error("invalid class kind %s", kind.toString());
        }
        return String.format("%s %s", name, classType.getName());
    }

    public String dumpArgList(ArgumentList list) {
        StringBuilder sb = new StringBuilder();
        String comma = this.flags.intersects(2) ? ", " : ",";
        List args2 = list.getArguments().stream().map(this::dumpIndex).collect(Collectors.toList());
        return StringUtils.join(args2, comma);
    }

    public static String getPrimitiveString(PrimitiveKind kind) {
        switch (kind) {
            case NoType: {
                return "<NoType>";
            }
            case Void: {
                return "void";
            }
            case Char: {
                return "signed char";
            }
            case UChar: {
                return "unsigned char";
            }
            case RChar: {
                return "char";
            }
            case WChar: {
                return "wchar_t";
            }
            case RChar16: {
                return "char16_t";
            }
            case RChar32: {
                return "char32_t";
            }
            case I8: {
                return "int8_t";
            }
            case U8: {
                return "uint8_t";
            }
            case Short: {
                return "short";
            }
            case UShort: {
                return "unsigned short";
            }
            case I16: {
                return "int16_t";
            }
            case U16: {
                return "uint16_t";
            }
            case Long: {
                return "long";
            }
            case ULong: {
                return "unsigned long";
            }
            case I32: {
                return "int";
            }
            case U32: {
                return "unsigned int";
            }
            case Quad: {
                return "long long";
            }
            case UQuad: {
                return "unsigned long long";
            }
            case I64: {
                return "int64_t";
            }
            case U64: {
                return "uint64_t";
            }
            case I128: 
            case Octa: {
                return "int128_t";
            }
            case U128: 
            case UOcta: {
                return "uint128_t";
            }
            case F16: {
                return "float16_t";
            }
            case F32: {
                return "float";
            }
            case F32PP: {
                return "float";
            }
            case F48: {
                return "float48_t";
            }
            case F64: {
                return "double";
            }
            case F80: {
                return "long double";
            }
            case F128: {
                return "long double";
            }
            case Complex32: {
                return "complex<float>";
            }
            case Complex64: {
                return "complex<double>";
            }
            case Complex80: {
                return "complex<long double>";
            }
            case Complex128: {
                return "complex<long double>";
            }
            case Bool8: {
                return "bool";
            }
            case Bool16: {
                return "bool16_t";
            }
            case Bool32: {
                return "bool32_t";
            }
            case Bool64: {
                return "bool64_t";
            }
            case HRESULT: {
                return "HRESULT";
            }
        }
        return null;
    }

    public String dumpPrimitive(PrimitiveType prim, boolean isConst) {
        String name = TypeDumper.getPrimitiveString(prim.getKind());
        if (name == null) {
            Log.error("Unsupported primitive type %s", prim.getKind().toString());
            System.exit(0);
        }
        if (prim.getIndirection() != null) {
            if (this.flags.intersects(4)) {
                if (isConst) {
                    return String.format("%s const *", name);
                }
                return String.format("%s *", name);
            }
            if (isConst) {
                return String.format("%s const*", name);
            }
            return String.format("%s*", name);
        }
        if (isConst) {
            return String.format("const %s", name);
        }
        return name;
    }

    public String dumpIndex(TypeIndex index) {
        TypeData typ = this.find(index);
        return this.dumpData(typ);
    }

    public String dumpNamed(String base, String name) {
        if (this.flags.intersects(8)) {
            return name;
        }
        return String.format("%s %s", base, name);
    }

    public String dumpData(TypeData typ) {
        if (typ.containsKey((Object)TypeEnum.Primitive)) {
            PrimitiveType t = (PrimitiveType)typ.get((Object)TypeEnum.Primitive);
            return this.dumpPrimitive(t, false);
        }
        if (typ.containsKey((Object)TypeEnum.Class)) {
            ClassType t = (ClassType)typ.get((Object)TypeEnum.Class);
            return this.dumpClass(t);
        }
        if (typ.containsKey((Object)TypeEnum.MemberFunction)) {
            MemberFunctionType t = (MemberFunctionType)typ.get((Object)TypeEnum.MemberFunction);
            Quaternion<Boolean, Boolean, String, String> q = this.dumpMethodParts(t, this.flags.intersects(1));
            String ret = (String)q.v3;
            String args2 = (String)q.v4;
            return String.format("%s()(%s)", this.fixReturn(ret), args2);
        }
        if (typ.containsKey((Object)TypeEnum.Procedure)) {
            ProcedureType t = (ProcedureType)typ.get((Object)TypeEnum.Procedure);
            Pair<String, String> p = this.dumpProcedureParts(t, this.flags.intersects(1));
            return String.format("%s()(%s)", this.fixReturn(p.getKey()), p.getValue());
        }
        if (typ.containsKey((Object)TypeEnum.ArgumentList)) {
            ArgumentList t = (ArgumentList)typ.get((Object)TypeEnum.ArgumentList);
            return this.dumpArgList(t);
        }
        if (typ.containsKey((Object)TypeEnum.Pointer)) {
            PointerType t = (PointerType)typ.get((Object)TypeEnum.Pointer);
            return this.dumpPtr(t, false);
        }
        if (typ.containsKey((Object)TypeEnum.Array)) {
            ArrayType t = (ArrayType)typ.get((Object)TypeEnum.Array);
            return this.dumpArray(t);
        }
        if (typ.containsKey((Object)TypeEnum.Union)) {
            UnionType t = (UnionType)typ.get((Object)TypeEnum.Union);
            return this.dumpNamed("union", t.getName());
        }
        if (typ.containsKey((Object)TypeEnum.Enumeration)) {
            EnumerationType t = (EnumerationType)typ.get((Object)TypeEnum.Enumeration);
            return this.dumpNamed("enum", t.getName());
        }
        if (typ.containsKey((Object)TypeEnum.Enumerate)) {
            EnumerateType t = (EnumerateType)typ.get((Object)TypeEnum.Enumerate);
            return this.dumpNamed("enum class", t.getName());
        }
        if (typ.containsKey((Object)TypeEnum.Modifier)) {
            ModifierType t = (ModifierType)typ.get((Object)TypeEnum.Modifier);
            return this.dumpModifier(t);
        }
        return String.format("unhandled type /* %s */", typ);
    }
}

