/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.types;

import com.uqm.crashsight.symtabtool.common.utils.StrUtils;
import com.uqm.crashsight.symtabtool.pdb.types.DemangleOptions;
import com.uqm.crashsight.symtabtool.pdb.types.Language;
import com.uqm.crashsight.symtabtool.pdb.types.NameMangling;

public class Name {
    String string;
    Language lang;
    NameMangling mangling;

    public Name(String string, NameMangling mangling, Language lang) {
        this.string = string;
        this.mangling = mangling;
        this.lang = lang;
    }

    public Language detectLanguage() {
        if (this.lang != Language.Unknown) {
            return this.lang;
        }
        if (Name.isMaybeObjc(this.string)) {
            return Language.ObjC;
        }
        if (Name.isMaybeCpp(this.string) || Name.isMaybeMsvc(this.string)) {
            return Language.Cpp;
        }
        return Language.Unknown;
    }

    public static boolean isMaybeObjc(String ident) {
        return (ident.startsWith("-[") || ident.startsWith("+[")) && ident.endsWith("]");
    }

    public static boolean isMaybeCpp(String ident) {
        return ident.startsWith("_Z") || ident.startsWith("__Z") || ident.endsWith("___Z") || ident.startsWith("____Z");
    }

    public static boolean isMaybeMsvc(String ident) {
        return ident.startsWith("?") || ident.startsWith("@?");
    }

    public static boolean isMaybeMd5(String ident) {
        if (ident.length() != 36) {
            return false;
        }
        return ident.startsWith("??@") && ident.endsWith("@") && StrUtils.isAsciiHexDigit(ident.substring(3, 35));
    }

    public String demangle(DemangleOptions opts) {
        if (this.mangling == NameMangling.Unmangled || Name.isMaybeMd5(this.string)) {
            return this.string;
        }
        switch (this.detectLanguage()) {
            case ObjC: {
                return Name.demangleObjc(this.string, opts);
            }
            case ObjCpp: {
                return Name.tryDemangleObjCpp(this.string, opts);
            }
            case Rust: {
                return Name.tryDemangleRust(this.string, opts);
            }
            case Cpp: {
                return Name.tryDemangleCpp(this.string, opts);
            }
            case Swift: {
                return Name.tryDemangleSwift(this.string, opts);
            }
        }
        return null;
    }

    public static String demangleObjc(String ident, DemangleOptions opts) {
        return ident;
    }

    public static String tryDemangleObjCpp(String ident, DemangleOptions opts) {
        return ident;
    }

    public static String tryDemangleRust(String ident, DemangleOptions opts) {
        return ident;
    }

    public static String tryDemangleCpp(String ident, DemangleOptions opts) {
        return ident;
    }

    public static String tryDemangleSwift(String ident, DemangleOptions opts) {
        return ident;
    }

    public static String demangleObjCpp(String ident, DemangleOptions opts) {
        if (Name.isMaybeObjc(ident)) {
            return Name.demangleObjc(ident, opts);
        }
        if (Name.isMaybeCpp(ident)) {
            return Name.tryDemangleCpp(ident, opts);
        }
        return null;
    }

    public static String normalizeAnonymousNamespace(String text) {
        return text.replace("`anonymous namespace'", "(anonymous namespace)");
    }

    public static Name fixSymbolName(Name name) {
        String fixed = name.getString().replaceAll("\\.llm\\.[0-9]+$]", "");
        fixed = Name.normalizeAnonymousNamespace(fixed);
        return new Name(fixed, name.mangling, name.lang);
    }

    public String getString() {
        return this.string;
    }

    public Language getLang() {
        return this.lang;
    }

    public NameMangling getMangling() {
        return this.mangling;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setLang(Language lang) {
        this.lang = lang;
    }

    public void setMangling(NameMangling mangling) {
        this.mangling = mangling;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name other = (Name)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$string = this.getString();
        String other$string = other.getString();
        if (this$string == null ? other$string != null : !this$string.equals(other$string)) {
            return false;
        }
        Language this$lang = this.getLang();
        Language other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !((Object)((Object)this$lang)).equals((Object)other$lang)) {
            return false;
        }
        NameMangling this$mangling = this.getMangling();
        NameMangling other$mangling = other.getMangling();
        return !(this$mangling == null ? other$mangling != null : !((Object)((Object)this$mangling)).equals((Object)other$mangling));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Name;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $string = this.getString();
        result = result * 59 + ($string == null ? 43 : $string.hashCode());
        Language $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)((Object)$lang)).hashCode());
        NameMangling $mangling = this.getMangling();
        result = result * 59 + ($mangling == null ? 43 : ((Object)((Object)$mangling)).hashCode());
        return result;
    }

    public String toString() {
        return "Name(string=" + this.getString() + ", lang=" + (Object)((Object)this.getLang()) + ", mangling=" + (Object)((Object)this.getMangling()) + ")";
    }
}

