/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.common.Variant;
import com.uqm.crashsight.symtabtool.pdb.common.VariantEnum;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.ArgumentList;
import com.uqm.crashsight.symtabtool.pdb.tpi.ArrayType;
import com.uqm.crashsight.symtabtool.pdb.tpi.BaseClassType;
import com.uqm.crashsight.symtabtool.pdb.tpi.BitfieldType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ClassKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.ClassType;
import com.uqm.crashsight.symtabtool.pdb.tpi.EnumerateType;
import com.uqm.crashsight.symtabtool.pdb.tpi.EnumerationType;
import com.uqm.crashsight.symtabtool.pdb.tpi.FieldAttributes;
import com.uqm.crashsight.symtabtool.pdb.tpi.FieldList;
import com.uqm.crashsight.symtabtool.pdb.tpi.MemberFunctionType;
import com.uqm.crashsight.symtabtool.pdb.tpi.MemberType;
import com.uqm.crashsight.symtabtool.pdb.tpi.MethodList;
import com.uqm.crashsight.symtabtool.pdb.tpi.MethodListEntry;
import com.uqm.crashsight.symtabtool.pdb.tpi.MethodType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ModifierType;
import com.uqm.crashsight.symtabtool.pdb.tpi.NestedType;
import com.uqm.crashsight.symtabtool.pdb.tpi.OverloadedMethodType;
import com.uqm.crashsight.symtabtool.pdb.tpi.PFunctionAttributes;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerAttributes;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ProcedureType;
import com.uqm.crashsight.symtabtool.pdb.tpi.StaticMemberType;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeInterface;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeProperties;
import com.uqm.crashsight.symtabtool.pdb.tpi.UnionType;
import com.uqm.crashsight.symtabtool.pdb.tpi.VirtualBaseClassType;
import com.uqm.crashsight.symtabtool.pdb.tpi.VirtualFunctionTablePointerType;
import java.util.ArrayList;
import java.util.EnumMap;

public class TypeData
extends EnumMap<TypeEnum, TypeInterface> {
    public TypeData(Class<TypeEnum> keyType) {
        super(keyType);
    }

    public static TypeIndex parseOptionalTypeIndex(ParseBuffer buffer) {
        long index = buffer.readU32();
        if (index == 0L || index == 65535L) {
            return null;
        }
        return new TypeIndex(index);
    }

    public static long parseUnsigned(ParseBuffer buffer) {
        int leaf = buffer.readU16();
        if (leaf < 32768) {
            return leaf;
        }
        switch (leaf) {
            case 32768: {
                return buffer.readU8();
            }
            case 32770: {
                return buffer.readU16();
            }
            case 32772: {
                return buffer.readU32();
            }
            case 32778: {
                return buffer.readI64();
            }
        }
        Log.error("UnexpectedNumericPrefix", new Object[0]);
        return leaf;
    }

    public static String parseString(int leaf, ParseBuffer buffer) {
        if (leaf > 5376) {
            return buffer.readCString();
        }
        return buffer.readU8PascalStr();
    }

    public static TypeData parseTypeData(ParseBuffer buf) {
        TypeData self = new TypeData(TypeEnum.class);
        int leaf = buf.readU16();
        switch (leaf) {
            case 4100: 
            case 4101: 
            case 5380: 
            case 5381: 
            case 5401: {
                ClassType classType = new ClassType();
                switch (leaf) {
                    case 4100: 
                    case 5380: {
                        classType.kind = ClassKind.Class;
                        break;
                    }
                    case 4101: 
                    case 5381: {
                        classType.kind = ClassKind.Struct;
                        break;
                    }
                    default: {
                        classType.kind = ClassKind.Interface;
                    }
                }
                classType.count = buf.readU16();
                classType.properties = new TypeProperties(buf.readU16());
                classType.fields = TypeData.parseOptionalTypeIndex(buf);
                classType.derivedFrom = TypeData.parseOptionalTypeIndex(buf);
                classType.vtableShape = TypeData.parseOptionalTypeIndex(buf);
                classType.size = (int)TypeData.parseUnsigned(buf);
                classType.name = TypeData.parseString(leaf, buf);
                classType.uniqueName = null;
                self.put(TypeEnum.Class, classType);
                break;
            }
            case 5641: {
                ClassType classType = new ClassType();
                classType.kind = ClassKind.Struct;
                classType.properties = new TypeProperties(buf.readU16());
                classType.fields = TypeData.parseOptionalTypeIndex(buf);
                classType.derivedFrom = TypeData.parseOptionalTypeIndex(buf);
                classType.vtableShape = TypeData.parseOptionalTypeIndex(buf);
                classType.count = buf.readU16();
                classType.size = (int)TypeData.parseUnsigned(buf);
                classType.name = TypeData.parseString(leaf, buf);
                classType.uniqueName = null;
                if (classType.properties.has_unique_name()) {
                    classType.uniqueName = TypeData.parseString(leaf, buf);
                }
                self.put(TypeEnum.Class, classType);
                break;
            }
            case 5125: 
            case 5389: {
                MemberType memberType = new MemberType();
                memberType.attributes = new FieldAttributes(buf.readU16());
                memberType.field_type = new TypeIndex(buf.readU32());
                memberType.offset = (int)TypeData.parseUnsigned(buf);
                memberType.name = TypeData.parseString(leaf, buf);
                self.put(TypeEnum.Member, memberType);
                break;
            }
            case 5128: 
            case 5133: 
            case 5392: 
            case 5394: {
                int rawAttr = 0;
                if (leaf == 5394 || leaf == 5133) {
                    rawAttr = buf.readU16();
                } else {
                    buf.readU16();
                }
                NestedType nestedType = new NestedType();
                nestedType.attributes = new FieldAttributes(rawAttr);
                nestedType.nested_type = new TypeIndex(buf.readU32());
                self.put(TypeEnum.Nested, nestedType);
                break;
            }
            case 4105: {
                MemberFunctionType type = new MemberFunctionType();
                type.returnType = TypeIndex.parse(buf);
                type.classType = TypeIndex.parse(buf);
                type.thisPointerType = TypeData.parseOptionalTypeIndex(buf);
                type.attributes = PFunctionAttributes.parse(buf);
                type.parameterCount = buf.readU16();
                type.argumentList = TypeIndex.parse(buf);
                self.put(TypeEnum.MemberFunction, type);
                break;
            }
            case 5127: 
            case 5391: {
                OverloadedMethodType methodType = new OverloadedMethodType();
                methodType.count = buf.readU16();
                methodType.method_list = TypeIndex.parse(buf);
                methodType.name = TypeData.parseString(leaf, buf);
                self.put(TypeEnum.OverloadedMethod, methodType);
                break;
            }
            case 5131: 
            case 5393: {
                FieldAttributes fieldAttributes = FieldAttributes.parse(buf);
                MethodType methodType = new MethodType();
                methodType.attributes = fieldAttributes;
                methodType.method_type = TypeIndex.parse(buf);
                methodType.vtable_offset = fieldAttributes.isIntroVirtual() ? buf.readU32() : 0L;
                methodType.name = TypeData.parseString(leaf, buf);
                self.put(TypeEnum.Method, methodType);
                break;
            }
            case 5120: 
            case 5402: {
                BaseClassType classType = new BaseClassType();
                switch (leaf) {
                    case 5120: {
                        classType.kind = ClassKind.Class;
                        break;
                    }
                    case 5402: {
                        classType.kind = ClassKind.Interface;
                        break;
                    }
                    default: {
                        Log.error("kind unreachable", new Object[0]);
                    }
                }
                classType.attributes = FieldAttributes.parse(buf);
                classType.baseClass = TypeIndex.parse(buf);
                classType.offset = TypeData.parseUnsigned(buf);
                self.put(TypeEnum.BaseClass, classType);
                break;
            }
            case 5129: {
                buf.readU16();
                VirtualFunctionTablePointerType pointerType = new VirtualFunctionTablePointerType();
                pointerType.table = TypeIndex.parse(buf);
                self.put(TypeEnum.VirtualFunctionTablePointer, pointerType);
                break;
            }
            case 5126: 
            case 5390: {
                StaticMemberType memberType = new StaticMemberType();
                memberType.attributes = FieldAttributes.parse(buf);
                memberType.fieldType = TypeIndex.parse(buf);
                memberType.name = TypeData.parseString(leaf, buf);
                self.put(TypeEnum.StaticMember, memberType);
                break;
            }
            case 4098: {
                TypeIndex underlyingType = TypeIndex.parse(buf);
                PointerAttributes pointerAttributes = PointerAttributes.parse(buf);
                TypeIndex containingClass = pointerAttributes.pointerToMember() ? TypeIndex.parse(buf) : null;
                PointerType pointerType = new PointerType();
                pointerType.underlyingType = underlyingType;
                pointerType.attributes = pointerAttributes;
                pointerType.containingClass = containingClass;
                self.put(TypeEnum.Pointer, pointerType);
                break;
            }
            case 4104: {
                ProcedureType procedureType = new ProcedureType();
                procedureType.returnType = TypeData.parseOptionalTypeIndex(buf);
                procedureType.attributes = PFunctionAttributes.parse(buf);
                procedureType.parameterCount = buf.readU16();
                procedureType.argumentList = TypeIndex.parse(buf);
                self.put(TypeEnum.Procedure, procedureType);
                break;
            }
            case 4097: {
                TypeIndex typeIndex = TypeIndex.parse(buf);
                int flags = buf.readU16();
                ModifierType type = new ModifierType();
                type.underlyingType = typeIndex;
                type.constant = (flags & 1) != 0;
                type.pVolatile = (flags & 2) != 0;
                type.unaligned = (flags & 4) != 0;
                self.put(TypeEnum.Modifier, type);
                break;
            }
            case 4103: 
            case 5383: {
                EnumerationType enumeration = new EnumerationType();
                enumeration.count = buf.readU16();
                enumeration.properties = new TypeProperties(buf.readU16());
                enumeration.underlyingType = new TypeIndex(buf.readU32());
                enumeration.fields = new TypeIndex(buf.readU32());
                enumeration.name = TypeData.parseString(leaf, buf);
                enumeration.uniqueName = null;
                self.put(TypeEnum.Enumeration, enumeration);
                break;
            }
            case 1027: 
            case 5378: {
                EnumerateType type = new EnumerateType();
                type.attributes = new FieldAttributes(buf.readU16());
                type.value = new Variant(VariantEnum.class).parse(buf);
                type.name = TypeData.parseString(leaf, buf);
                self.put(TypeEnum.Enumerate, type);
                break;
            }
            case 4099: 
            case 5379: 
            case 5398: {
                TypeIndex elementType = new TypeIndex(buf.readU32());
                TypeIndex indexingType = new TypeIndex(buf.readU32());
                Long stride = leaf == 5398 ? Long.valueOf(buf.readU32()) : null;
                ArrayList<Long> dimensions = new ArrayList<Long>();
                do {
                    long dim;
                    if ((dim = TypeData.parseUnsigned(buf)) > 0xFFFFFFFFL) {
                        Log.error("Unsupported symbol data format(u64 array sizes)", new Object[0]);
                        return self;
                    }
                    dimensions.add(dim);
                    if (!buf.isEmpty()) continue;
                    Log.error("UnexpectedEof", new Object[0]);
                    return self;
                } while (buf.getU8() != 0);
                buf.readU8();
                TypeData.parsePadding(buf);
                assert (buf.isEmpty());
                self.put(TypeEnum.Array, new ArrayType(elementType, indexingType, stride, dimensions));
                break;
            }
            case 4102: 
            case 5382: {
                UnionType union = new UnionType(buf.readU16(), new TypeProperties(buf.readU16()), new TypeIndex(buf.readU32()), TypeData.parseUnsigned(buf), TypeData.parseString(leaf, buf), null);
                if (union.properties.has_unique_name()) {
                    union.uniqueName = TypeData.parseString(leaf, buf);
                }
                self.put(TypeEnum.Union, union);
                break;
            }
            case 4613: {
                self.put(TypeEnum.Bitfield, new BitfieldType(new TypeIndex(buf.readU32()), buf.readU8(), buf.readU8()));
                break;
            }
            case 10: 
            case 5405: {
                break;
            }
            case 5121: 
            case 5122: {
                self.put(TypeEnum.VirtualBaseClass, new VirtualBaseClassType(leaf == 5121, new FieldAttributes(buf.readU16()), new TypeIndex(buf.readU32()), new TypeIndex(buf.readU32()), TypeData.parseUnsigned(buf), TypeData.parseUnsigned(buf)));
                break;
            }
            case 4611: {
                ArrayList<TypeData> fields = new ArrayList<TypeData>();
                TypeIndex continuation = null;
                while (!buf.isEmpty()) {
                    int p = buf.getU16();
                    if (p == 5124) {
                        buf.readU16();
                        continuation = new TypeIndex(buf.readU32());
                    } else {
                        fields.add(TypeData.parseTypeData(buf));
                    }
                    TypeData.parsePadding(buf);
                }
                self.put(TypeEnum.FieldList, new FieldList(fields, continuation));
                break;
            }
            case 4609: {
                long count = buf.readU32();
                ArrayList<TypeIndex> argList = new ArrayList<TypeIndex>((int)count);
                int i = 0;
                while ((long)i < count) {
                    argList.add(new TypeIndex(buf.readU32()));
                    ++i;
                }
                self.put(TypeEnum.ArgumentList, new ArgumentList(argList));
                break;
            }
            case 4614: {
                ArrayList<MethodListEntry> methods = new ArrayList<MethodListEntry>();
                while (!buf.isEmpty()) {
                    FieldAttributes attr = new FieldAttributes(buf.readU16());
                    buf.readU16();
                    methods.add(new MethodListEntry(attr, new TypeIndex(buf.readU32()), attr.isIntroVirtual() ? Long.valueOf(buf.readU32()) : null));
                }
                self.put(TypeEnum.MethodList, new MethodList(methods));
                break;
            }
        }
        return self;
    }

    public static void parsePadding(ParseBuffer buf) {
        while (!buf.isEmpty() && buf.getU8() >= 240) {
            short padding = buf.readU8();
            if (padding <= 240) continue;
            buf.take((padding & 0xF) - 1);
        }
    }
}

