/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.tpi.Indirection;
import com.uqm.crashsight.symtabtool.pdb.tpi.PrimitiveKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.PrimitiveType;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeData;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;

public class Primitive {
    public static TypeData typeDataForPrimitive(TypeIndex typeIndex) {
        long index = typeIndex.index;
        assert (index < 4096L);
        int v = (int)(index & 0xF00L);
        Indirection indirection = null;
        switch (v) {
            case 0: {
                indirection = null;
                break;
            }
            case 256: {
                indirection = Indirection.Near16;
                break;
            }
            case 512: {
                indirection = Indirection.Far16;
                break;
            }
            case 768: {
                indirection = Indirection.Huge16;
                break;
            }
            case 1024: {
                indirection = Indirection.Near32;
                break;
            }
            case 1280: {
                indirection = Indirection.Far32;
                break;
            }
            case 1536: {
                indirection = Indirection.Near64;
                break;
            }
            case 1792: {
                indirection = Indirection.Near128;
                break;
            }
            default: {
                Log.error("TypeNotFound(%d)", index);
            }
        }
        v = (int)index & 0xFF;
        PrimitiveKind kind = null;
        switch (v) {
            case 0: {
                kind = PrimitiveKind.NoType;
                break;
            }
            case 3: {
                kind = PrimitiveKind.Void;
                break;
            }
            case 8: {
                kind = PrimitiveKind.HRESULT;
                break;
            }
            case 16: {
                kind = PrimitiveKind.Char;
                break;
            }
            case 32: {
                kind = PrimitiveKind.UChar;
                break;
            }
            case 104: {
                kind = PrimitiveKind.I8;
                break;
            }
            case 105: {
                kind = PrimitiveKind.U8;
                break;
            }
            case 112: {
                kind = PrimitiveKind.RChar;
                break;
            }
            case 113: {
                kind = PrimitiveKind.WChar;
                break;
            }
            case 122: {
                kind = PrimitiveKind.RChar16;
                break;
            }
            case 123: {
                kind = PrimitiveKind.RChar32;
                break;
            }
            case 17: {
                kind = PrimitiveKind.Short;
                break;
            }
            case 33: {
                kind = PrimitiveKind.UShort;
                break;
            }
            case 114: {
                kind = PrimitiveKind.I16;
                break;
            }
            case 115: {
                kind = PrimitiveKind.U16;
                break;
            }
            case 18: {
                kind = PrimitiveKind.Long;
                break;
            }
            case 34: {
                kind = PrimitiveKind.ULong;
                break;
            }
            case 116: {
                kind = PrimitiveKind.I32;
                break;
            }
            case 117: {
                kind = PrimitiveKind.U32;
                break;
            }
            case 19: {
                kind = PrimitiveKind.Quad;
                break;
            }
            case 35: {
                kind = PrimitiveKind.UQuad;
                break;
            }
            case 118: {
                kind = PrimitiveKind.I64;
                break;
            }
            case 119: {
                kind = PrimitiveKind.U64;
                break;
            }
            case 20: {
                kind = PrimitiveKind.Octa;
                break;
            }
            case 36: {
                kind = PrimitiveKind.UOcta;
                break;
            }
            case 120: {
                kind = PrimitiveKind.I128;
                break;
            }
            case 121: {
                kind = PrimitiveKind.U128;
                break;
            }
            case 70: {
                kind = PrimitiveKind.F16;
                break;
            }
            case 64: {
                kind = PrimitiveKind.F32;
                break;
            }
            case 69: {
                kind = PrimitiveKind.F32PP;
                break;
            }
            case 68: {
                kind = PrimitiveKind.F48;
                break;
            }
            case 65: {
                kind = PrimitiveKind.F64;
                break;
            }
            case 66: {
                kind = PrimitiveKind.F80;
                break;
            }
            case 67: {
                kind = PrimitiveKind.F128;
                break;
            }
            case 80: {
                kind = PrimitiveKind.Complex32;
                break;
            }
            case 81: {
                kind = PrimitiveKind.Complex64;
                break;
            }
            case 82: {
                kind = PrimitiveKind.Complex80;
                break;
            }
            case 83: {
                kind = PrimitiveKind.Complex128;
                break;
            }
            case 48: {
                kind = PrimitiveKind.Bool8;
                break;
            }
            case 49: {
                kind = PrimitiveKind.Bool16;
                break;
            }
            case 50: {
                kind = PrimitiveKind.Bool32;
                break;
            }
            case 51: {
                kind = PrimitiveKind.Bool64;
                break;
            }
            default: {
                Log.error("TypeNotFound(%d)", index);
            }
        }
        PrimitiveType primitiveType = new PrimitiveType(kind, indirection);
        TypeData typeData = new TypeData(TypeEnum.class);
        typeData.put(TypeEnum.Primitive, primitiveType);
        return typeData;
    }
}

