/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerMode;

public class PointerAttributes {
    long value;

    public PointerAttributes(long value) {
        this.value = value;
    }

    public static PointerAttributes parse(ParseBuffer buffer) {
        return new PointerAttributes(buffer.readU32());
    }

    public PointerMode pointerMode() {
        long v = this.value >> 5 & 7L;
        switch ((int)v) {
            case 0: {
                return PointerMode.Pointer;
            }
            case 1: {
                return PointerMode.LValueReference;
            }
            case 2: {
                return PointerMode.Member;
            }
            case 3: {
                return PointerMode.MemberFunction;
            }
            case 4: {
                return PointerMode.RValueReference;
            }
        }
        return null;
    }

    boolean pointerToMember() {
        PointerMode mode = this.pointerMode();
        return mode == PointerMode.Member || mode == PointerMode.MemberFunction;
    }

    public PointerKind pointerKind() {
        int v = (int)this.value & 0x1F;
        switch (v) {
            case 0: {
                return PointerKind.Near16;
            }
            case 1: {
                return PointerKind.Far16;
            }
            case 2: {
                return PointerKind.Huge16;
            }
            case 3: {
                return PointerKind.BaseSeg;
            }
            case 4: {
                return PointerKind.BaseVal;
            }
            case 5: {
                return PointerKind.BaseSegVal;
            }
            case 6: {
                return PointerKind.BaseAddr;
            }
            case 7: {
                return PointerKind.BaseSegAddr;
            }
            case 8: {
                return PointerKind.BaseType;
            }
            case 9: {
                return PointerKind.BaseSelf;
            }
            case 10: {
                return PointerKind.Near32;
            }
            case 11: {
                return PointerKind.Far32;
            }
            case 12: {
                return PointerKind.Ptr64;
            }
        }
        Log.error("unreachable", new Object[0]);
        return null;
    }

    public int size() {
        long size = this.value >> 13 & 0x3FL;
        if (size != 0L) {
            return (int)size;
        }
        PointerKind kind = this.pointerKind();
        switch (kind) {
            case Near32: 
            case Far32: {
                return 4;
            }
            case Ptr64: {
                return 8;
            }
        }
        return 0;
    }

    public boolean isConst() {
        return (this.value & 0x400L) != 0L;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PointerAttributes)) {
            return false;
        }
        PointerAttributes other = (PointerAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getValue() == other.getValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PointerAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    public String toString() {
        return "PointerAttributes(value=" + this.getValue() + ")";
    }
}

