/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.Constants;
import com.uqm.crashsight.symtabtool.pdb.tpi.Item;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemInformation;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemIter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ItemFinder {
    ParseBuffer buffer;
    long minimumIndex;
    long maximumIndex;
    List<Long> positions;
    short shift;

    public ItemFinder(ItemInformation info, short shift) {
        long count = info.header.maximumIndex - info.header.minimumIndex;
        long roundBase = (1L << shift) - 1L;
        long shiftedCount = (count + roundBase & (roundBase ^ 0xFFFFFFFFFFFFFFFFL)) >> shift;
        ArrayList<Long> positions = new ArrayList<Long>((int)shiftedCount);
        if (shiftedCount > 0L) {
            positions.add(info.header.headSize);
        }
        this.buffer = info.buffer.copyRef();
        this.minimumIndex = info.header.minimumIndex;
        this.maximumIndex = info.header.maximumIndex;
        this.positions = positions;
        this.shift = shift;
    }

    Pair<Long, Long> resolve(long typeIndex) {
        long raw = typeIndex - this.minimumIndex;
        return new Pair<Long, Long>(raw >> this.shift, raw & (1L << this.shift) - 1L);
    }

    public ItemIndex maxIndex() {
        int len = this.positions.size();
        if (len == 0) {
            return new ItemIndex(0L);
        }
        return new ItemIndex(((long)len << this.shift) + this.minimumIndex + 1L);
    }

    public void update(ItemIter iter) {
        Pair<Long, Long> pair = this.resolve(iter.index);
        long iterationCount = pair.getValue();
        long vecIndex = pair.getKey();
        if (iterationCount == 0L && vecIndex == (long)this.positions.size()) {
            long pos = iter.buffer.pos();
            assert (pos < 0xFFFFFFFFL);
            this.positions.add(pos);
        }
    }

    public Item find(long index) {
        if (index < this.minimumIndex) {
            ParseBuffer buffer = new ParseBuffer(ByteBuffer.wrap(Constants.PRIMITIVE_TYPE), 0L);
            return new Item(index, buffer);
        }
        if (index > this.maximumIndex) {
            Log.error("TypeNotFound(%d)", index);
            return null;
        }
        Pair<Long, Long> pair = this.resolve(index);
        long iterationCount = pair.getValue();
        long vecIndex = pair.getKey();
        Long pos = this.positions.get((int)vecIndex);
        if (pos != null) {
            ParseBuffer buf = this.buffer.copyRef();
            buf.pos(buf.pos() + pos);
            int j = 0;
            while ((long)j < iterationCount) {
                int length = buf.readU16();
                buf.pos(buf.pos() + (long)length);
                ++j;
            }
            int length = buf.readU16();
            return new Item(index, buf.take(length));
        }
        Log.error("TypeNotIndexed", new Object[0]);
        return null;
    }
}

