/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.BuildInfoId;
import com.uqm.crashsight.symtabtool.pdb.tpi.FunctionId;
import com.uqm.crashsight.symtabtool.pdb.tpi.IdEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.IdIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.IdInterface;
import com.uqm.crashsight.symtabtool.pdb.tpi.MemberFunctionId;
import com.uqm.crashsight.symtabtool.pdb.tpi.StringId;
import com.uqm.crashsight.symtabtool.pdb.tpi.StringListId;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.UserDefinedTypeSourceFileRef;
import com.uqm.crashsight.symtabtool.pdb.tpi.UserDefinedTypeSourceId;
import java.util.ArrayList;
import java.util.EnumMap;

public class IdData
extends EnumMap<IdEnum, IdInterface> {
    public IdData(Class<IdEnum> keyType) {
        super(keyType);
    }

    public static IdIndex parseOptionalTypeIndex(ParseBuffer buffer) {
        long index = buffer.readU32();
        if (index == 0L) {
            return null;
        }
        return new IdIndex(index);
    }

    public static String parseString(int leaf, ParseBuffer buffer) {
        if (leaf > 5376) {
            return buffer.readCString();
        }
        return buffer.readU8PascalStr();
    }

    public void parse(ParseBuffer buffer) {
        int leaf = buffer.readU16();
        switch (leaf) {
            case 5633: {
                FunctionId functionId = new FunctionId();
                functionId.scope = IdData.parseOptionalTypeIndex(buffer);
                functionId.functionType = TypeIndex.parse(buffer);
                functionId.name = IdData.parseString(leaf, buffer);
                this.put(IdEnum.Function, functionId);
                break;
            }
            case 5634: {
                MemberFunctionId functionId = new MemberFunctionId();
                functionId.parent = TypeIndex.parse(buffer);
                functionId.functionType = TypeIndex.parse(buffer);
                functionId.name = IdData.parseString(leaf, buffer);
                this.put(IdEnum.MemberFunction, functionId);
                break;
            }
            case 5635: {
                int count = buffer.readU16();
                ArrayList<IdIndex> arguments = new ArrayList<IdIndex>(count);
                for (int i = 0; i < count; ++i) {
                    arguments.add(IdIndex.parse(buffer));
                }
                BuildInfoId buildInfoId = new BuildInfoId();
                buildInfoId.arguments = arguments;
                this.put(IdEnum.BuildInfo, buildInfoId);
                break;
            }
            case 5636: {
                StringListId stringListId = new StringListId();
                long count = buffer.readU32();
                ArrayList<TypeIndex> substrings = new ArrayList<TypeIndex>((int)count);
                int i = 0;
                while ((long)i < count) {
                    substrings.add(TypeIndex.parse(buffer));
                    ++i;
                }
                stringListId.substrings = substrings;
                this.put(IdEnum.StringList, stringListId);
                break;
            }
            case 5637: {
                StringId stringId = new StringId();
                stringId.substrings = IdData.parseOptionalTypeIndex(buffer);
                stringId.name = IdData.parseString(leaf, buffer);
                this.put(IdEnum.PString, stringId);
                break;
            }
            case 5638: 
            case 5639: {
                TypeIndex udt = TypeIndex.parse(buffer);
                long fileId = buffer.readU32();
                long line = buffer.readU32();
                UserDefinedTypeSourceId sourceId = new UserDefinedTypeSourceId();
                sourceId.sourceFile = leaf == 5638 ? new UserDefinedTypeSourceFileRef(new IdIndex(fileId), null) : new UserDefinedTypeSourceFileRef(null, new Pair<Integer, Long>(buffer.readU16(), fileId));
                sourceId.udt = udt;
                sourceId.line = line;
                this.put(IdEnum.UserDefinedTypeSource, sourceId);
                break;
            }
        }
    }
}

