/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.Slice;

public class Header {
    long version;
    long headSize;
    long minimumIndex;
    long maximumIndex;
    long gprecSize;
    int tpiHashStream;
    int tpiHashPadStream;
    long hashKeySize;
    long hashBucketSize;
    Slice hashValues;
    Slice tiOff;
    Slice hashAdj;

    public static Header empty() {
        Header header = new Header();
        header.tiOff = new Slice(0, 0L);
        header.hashAdj = new Slice(0, 0L);
        return header;
    }

    public static Header parse(ParseBuffer buffer) {
        assert (buffer.pos() == 0L);
        if (buffer.isEmpty()) {
            return Header.empty();
        }
        Header header = new Header();
        header.version = buffer.readU32();
        header.headSize = buffer.readU32();
        header.minimumIndex = buffer.readU32();
        header.maximumIndex = buffer.readU32();
        header.gprecSize = buffer.readU32();
        header.tpiHashStream = buffer.readU16();
        header.tpiHashPadStream = buffer.readU16();
        header.hashKeySize = buffer.readU32();
        header.hashBucketSize = buffer.readU32();
        header.hashValues = new Slice(buffer.readI32(), buffer.readU32());
        header.tiOff = new Slice(buffer.readI32(), buffer.readU32());
        header.hashAdj = new Slice(buffer.readI32(), buffer.readU32());
        long bytesRead = buffer.pos();
        if (header.headSize < bytesRead) {
            Log.error("header size is impossibly small", new Object[0]);
            return null;
        }
        if (header.headSize > 1024L) {
            Log.error("header size is unreasonably large", new Object[0]);
            return null;
        }
        buffer.pos(header.headSize);
        if (header.minimumIndex < 4096L) {
            Log.error("minimum type index is < 4096", new Object[0]);
            return null;
        }
        if (header.maximumIndex < header.minimumIndex) {
            Log.error("maximum type index is < minimum type index", new Object[0]);
            return null;
        }
        return header;
    }

    public long getVersion() {
        return this.version;
    }

    public long getHeadSize() {
        return this.headSize;
    }

    public long getMinimumIndex() {
        return this.minimumIndex;
    }

    public long getMaximumIndex() {
        return this.maximumIndex;
    }

    public long getGprecSize() {
        return this.gprecSize;
    }

    public int getTpiHashStream() {
        return this.tpiHashStream;
    }

    public int getTpiHashPadStream() {
        return this.tpiHashPadStream;
    }

    public long getHashKeySize() {
        return this.hashKeySize;
    }

    public long getHashBucketSize() {
        return this.hashBucketSize;
    }

    public Slice getHashValues() {
        return this.hashValues;
    }

    public Slice getTiOff() {
        return this.tiOff;
    }

    public Slice getHashAdj() {
        return this.hashAdj;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setHeadSize(long headSize) {
        this.headSize = headSize;
    }

    public void setMinimumIndex(long minimumIndex) {
        this.minimumIndex = minimumIndex;
    }

    public void setMaximumIndex(long maximumIndex) {
        this.maximumIndex = maximumIndex;
    }

    public void setGprecSize(long gprecSize) {
        this.gprecSize = gprecSize;
    }

    public void setTpiHashStream(int tpiHashStream) {
        this.tpiHashStream = tpiHashStream;
    }

    public void setTpiHashPadStream(int tpiHashPadStream) {
        this.tpiHashPadStream = tpiHashPadStream;
    }

    public void setHashKeySize(long hashKeySize) {
        this.hashKeySize = hashKeySize;
    }

    public void setHashBucketSize(long hashBucketSize) {
        this.hashBucketSize = hashBucketSize;
    }

    public void setHashValues(Slice hashValues) {
        this.hashValues = hashValues;
    }

    public void setTiOff(Slice tiOff) {
        this.tiOff = tiOff;
    }

    public void setHashAdj(Slice hashAdj) {
        this.hashAdj = hashAdj;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header other = (Header)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getHeadSize() != other.getHeadSize()) {
            return false;
        }
        if (this.getMinimumIndex() != other.getMinimumIndex()) {
            return false;
        }
        if (this.getMaximumIndex() != other.getMaximumIndex()) {
            return false;
        }
        if (this.getGprecSize() != other.getGprecSize()) {
            return false;
        }
        if (this.getTpiHashStream() != other.getTpiHashStream()) {
            return false;
        }
        if (this.getTpiHashPadStream() != other.getTpiHashPadStream()) {
            return false;
        }
        if (this.getHashKeySize() != other.getHashKeySize()) {
            return false;
        }
        if (this.getHashBucketSize() != other.getHashBucketSize()) {
            return false;
        }
        Slice this$hashValues = this.getHashValues();
        Slice other$hashValues = other.getHashValues();
        if (this$hashValues == null ? other$hashValues != null : !this$hashValues.equals(other$hashValues)) {
            return false;
        }
        Slice this$tiOff = this.getTiOff();
        Slice other$tiOff = other.getTiOff();
        if (this$tiOff == null ? other$tiOff != null : !this$tiOff.equals(other$tiOff)) {
            return false;
        }
        Slice this$hashAdj = this.getHashAdj();
        Slice other$hashAdj = other.getHashAdj();
        return !(this$hashAdj == null ? other$hashAdj != null : !this$hashAdj.equals(other$hashAdj));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Header;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $headSize = this.getHeadSize();
        result = result * 59 + (int)($headSize >>> 32 ^ $headSize);
        long $minimumIndex = this.getMinimumIndex();
        result = result * 59 + (int)($minimumIndex >>> 32 ^ $minimumIndex);
        long $maximumIndex = this.getMaximumIndex();
        result = result * 59 + (int)($maximumIndex >>> 32 ^ $maximumIndex);
        long $gprecSize = this.getGprecSize();
        result = result * 59 + (int)($gprecSize >>> 32 ^ $gprecSize);
        result = result * 59 + this.getTpiHashStream();
        result = result * 59 + this.getTpiHashPadStream();
        long $hashKeySize = this.getHashKeySize();
        result = result * 59 + (int)($hashKeySize >>> 32 ^ $hashKeySize);
        long $hashBucketSize = this.getHashBucketSize();
        result = result * 59 + (int)($hashBucketSize >>> 32 ^ $hashBucketSize);
        Slice $hashValues = this.getHashValues();
        result = result * 59 + ($hashValues == null ? 43 : $hashValues.hashCode());
        Slice $tiOff = this.getTiOff();
        result = result * 59 + ($tiOff == null ? 43 : $tiOff.hashCode());
        Slice $hashAdj = this.getHashAdj();
        result = result * 59 + ($hashAdj == null ? 43 : $hashAdj.hashCode());
        return result;
    }

    public String toString() {
        return "Header(version=" + this.getVersion() + ", headSize=" + this.getHeadSize() + ", minimumIndex=" + this.getMinimumIndex() + ", maximumIndex=" + this.getMaximumIndex() + ", gprecSize=" + this.getGprecSize() + ", tpiHashStream=" + this.getTpiHashStream() + ", tpiHashPadStream=" + this.getTpiHashPadStream() + ", hashKeySize=" + this.getHashKeySize() + ", hashBucketSize=" + this.getHashBucketSize() + ", hashValues=" + this.getHashValues() + ", tiOff=" + this.getTiOff() + ", hashAdj=" + this.getHashAdj() + ")";
    }
}

