/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.ThunkKind;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ThunkSymbol {
    Long parent;
    long end;
    Long next;
    PdbInternalSectionOffset offset;
    int len;
    ThunkKind kind;
    String name;

    public ThunkSymbol(Long parent, long end, Long next, PdbInternalSectionOffset offset, int len, ThunkKind kind, String name) {
        this.parent = parent;
        this.end = end;
        this.next = next;
        this.offset = offset;
        this.len = len;
        this.kind = kind;
        this.name = name;
    }

    public static ThunkSymbol parse(ParseBuffer buffer, int kind) {
        try {
            Long parent = Utils.parseOptionalIndex(buffer);
            long end = buffer.readU32();
            Long next = Utils.parseOptionalIndex(buffer);
            PdbInternalSectionOffset offset = PdbInternalSectionOffset.parse(buffer);
            int len = buffer.readU16();
            short ord = buffer.readU8();
            String name = Utils.parseSymbolName(buffer, kind);
            ThunkKind thunkKind = new ThunkKind();
            switch (ord) {
                case 0: {
                    thunkKind.noType = new ThunkKind.NoType();
                    break;
                }
                case 1: {
                    thunkKind.adjustor = ThunkKind.Adjustor.parse(buffer);
                    break;
                }
                case 2: {
                    thunkKind.vCall = buffer.readU16();
                    break;
                }
                case 3: {
                    thunkKind.pCode = new ThunkKind.PCode();
                    break;
                }
                case 4: {
                    thunkKind.load = new ThunkKind.Load();
                    break;
                }
                default: {
                    thunkKind.unknown = ord;
                }
            }
            return new ThunkSymbol(parent, end, next, offset, len, thunkKind, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public Long getNext() {
        return this.next;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public int getLen() {
        return this.len;
    }

    public ThunkKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setNext(Long next) {
        this.next = next;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setKind(ThunkKind kind) {
        this.kind = kind;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThunkSymbol)) {
            return false;
        }
        ThunkSymbol other = (ThunkSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        Long this$parent = this.getParent();
        Long other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Long this$next = this.getNext();
        Long other$next = other.getNext();
        if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        ThunkKind this$kind = this.getKind();
        ThunkKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThunkSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $end = this.getEnd();
        result = result * 59 + (int)($end >>> 32 ^ $end);
        result = result * 59 + this.getLen();
        Long $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Long $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        ThunkKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ThunkSymbol(parent=" + this.getParent() + ", end=" + this.getEnd() + ", next=" + this.getNext() + ", offset=" + this.getOffset() + ", len=" + this.getLen() + ", kind=" + this.getKind() + ", name=" + this.getName() + ")";
    }
}

