/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ThreadStorageSymbol {
    boolean global;
    long typeIndex;
    PdbInternalSectionOffset offset;
    String name;

    public ThreadStorageSymbol(boolean global, long typeIndex, PdbInternalSectionOffset offset, String name) {
        this.global = global;
        this.typeIndex = typeIndex;
        this.offset = offset;
        this.name = name;
    }

    public static ThreadStorageSymbol parse(ParseBuffer buffer, int kind) {
        try {
            return new ThreadStorageSymbol(kind == 4371 || kind == 4111, buffer.readU32(), PdbInternalSectionOffset.parse(buffer), Utils.parseSymbolName(buffer, kind));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public void setTypeIndex(long typeIndex) {
        this.typeIndex = typeIndex;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadStorageSymbol)) {
            return false;
        }
        ThreadStorageSymbol other = (ThreadStorageSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGlobal() != other.isGlobal()) {
            return false;
        }
        if (this.getTypeIndex() != other.getTypeIndex()) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadStorageSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobal() ? 79 : 97);
        long $typeIndex = this.getTypeIndex();
        result = result * 59 + (int)($typeIndex >>> 32 ^ $typeIndex);
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ThreadStorageSymbol(global=" + this.isGlobal() + ", typeIndex=" + this.getTypeIndex() + ", offset=" + this.getOffset() + ", name=" + this.getName() + ")";
    }
}

