/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.PSymbol;

public class SymbolIter {
    private ParseBuffer buffer;

    public SymbolIter(ParseBuffer buffer) {
        this.buffer = buffer;
    }

    public static SymbolIter empty() {
        return new SymbolIter(ParseBuffer.empty());
    }

    public void seek(long symbolIndex) {
        this.buffer.pos(symbolIndex);
    }

    public PSymbol skipTo(long symbolIndex) {
        this.seek(symbolIndex);
        return this.next();
    }

    public PSymbol next() {
        while (!this.buffer.isEmpty()) {
            long index = this.buffer.pos();
            long symbolLength = this.buffer.readU16();
            if (symbolLength < 2L) {
                Log.error("SymbolTooShort", new Object[0]);
                return null;
            }
            ParseBuffer data = this.buffer.take(symbolLength);
            PSymbol symbol = new PSymbol(index, data.array());
            if (symbol.getRawKind() == 1031) continue;
            return symbol;
        }
        return null;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ParseBuffer buffer) {
        this.buffer = buffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SymbolIter)) {
            return false;
        }
        SymbolIter other = (SymbolIter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ParseBuffer this$buffer = this.getBuffer();
        ParseBuffer other$buffer = other.getBuffer();
        return !(this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SymbolIter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParseBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        return result;
    }

    public String toString() {
        return "SymbolIter(buffer=" + this.getBuffer() + ")";
    }
}

