/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.SeparatedCodeFlags;

public class SeparatedCodeSymbol {
    long parent;
    long end;
    long len;
    SeparatedCodeFlags flags;
    PdbInternalSectionOffset offset;
    PdbInternalSectionOffset parentOffset;

    public SeparatedCodeSymbol(long parent, long end, long len, SeparatedCodeFlags flags, PdbInternalSectionOffset offset, PdbInternalSectionOffset parentOffset) {
        this.parent = parent;
        this.end = end;
        this.len = len;
        this.flags = flags;
        this.offset = offset;
        this.parentOffset = parentOffset;
    }

    public static SeparatedCodeSymbol parse(ParseBuffer buffer) {
        try {
            long parent = buffer.readU32();
            long end = buffer.readU32();
            long len = buffer.readU32();
            SeparatedCodeFlags flags = SeparatedCodeFlags.parse(buffer);
            long offset = buffer.readU32();
            long parentOffset = buffer.readU32();
            int section = buffer.readU16();
            int parentSection = buffer.readU16();
            return new SeparatedCodeSymbol(parent, end, len, flags, new PdbInternalSectionOffset(offset, section), new PdbInternalSectionOffset(parentOffset, parentSection));
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLen() {
        return this.len;
    }

    public SeparatedCodeFlags getFlags() {
        return this.flags;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public PdbInternalSectionOffset getParentOffset() {
        return this.parentOffset;
    }

    public void setParent(long parent) {
        this.parent = parent;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setLen(long len) {
        this.len = len;
    }

    public void setFlags(SeparatedCodeFlags flags) {
        this.flags = flags;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setParentOffset(PdbInternalSectionOffset parentOffset) {
        this.parentOffset = parentOffset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeparatedCodeSymbol)) {
            return false;
        }
        SeparatedCodeSymbol other = (SeparatedCodeSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getParent() != other.getParent()) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        SeparatedCodeFlags this$flags = this.getFlags();
        SeparatedCodeFlags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        PdbInternalSectionOffset this$parentOffset = this.getParentOffset();
        PdbInternalSectionOffset other$parentOffset = other.getParentOffset();
        return !(this$parentOffset == null ? other$parentOffset != null : !((Object)this$parentOffset).equals(other$parentOffset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeparatedCodeSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $parent = this.getParent();
        result = result * 59 + (int)($parent >>> 32 ^ $parent);
        long $end = this.getEnd();
        result = result * 59 + (int)($end >>> 32 ^ $end);
        long $len = this.getLen();
        result = result * 59 + (int)($len >>> 32 ^ $len);
        SeparatedCodeFlags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        PdbInternalSectionOffset $parentOffset = this.getParentOffset();
        result = result * 59 + ($parentOffset == null ? 43 : ((Object)$parentOffset).hashCode());
        return result;
    }

    public String toString() {
        return "SeparatedCodeSymbol(parent=" + this.getParent() + ", end=" + this.getEnd() + ", len=" + this.getLen() + ", flags=" + this.getFlags() + ", offset=" + this.getOffset() + ", parentOffset=" + this.getParentOffset() + ")";
    }
}

