/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.framedata.FrameTable;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceLineCollector;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.EBPInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PublicSymbol;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;
import com.uqm.crashsight.symtabtool.pdb.types.PFuncName;
import com.uqm.crashsight.symtabtool.pdb.types.TypeDumper;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SelectedSymbol {
    String name;
    long typeIndex;
    boolean isPublic;
    boolean isMultiple;
    PdbInternalSectionOffset offset;
    PdbInternalSectionOffset symOffset;
    long len;
    long parameterSize;
    Lines source;
    List<EBPInfo> ebp;
    long id;

    public SelectedSymbol(String name, long typeIndex, boolean isPublic, boolean isMultiple, PdbInternalSectionOffset offset, PdbInternalSectionOffset symOffset, long len, long parameterSize, Lines source2, List<EBPInfo> ebp, long id) {
        this.name = name;
        this.typeIndex = typeIndex;
        this.isPublic = isPublic;
        this.isMultiple = isMultiple;
        this.offset = offset;
        this.symOffset = symOffset;
        this.len = len;
        this.parameterSize = parameterSize;
        this.source = source2;
        this.ebp = ebp;
        this.id = id;
        if (offset.getOffset() == 13072L) {
            boolean bl = true;
        }
    }

    public PFuncName getUnd(TypeDumper dumper) {
        PFuncName name = dumper.dumpFunction(this.name, new TypeIndex(this.typeIndex));
        if (name == null) {
            return PFuncName.getUnknown(this.name);
        }
        return name;
    }

    public long getStackParamSize(TypeDumper dumper, AddressMap addressMap, FrameTable frameTable) {
        if (this.ebp.isEmpty()) {
            return this.parameterSize;
        }
        long minStart = 0xFFFFFFFFL;
        long maxEnd = 0L;
        for (EBPInfo ebpInfo : this.ebp) {
            minStart = Math.min(minStart, ebpInfo.offset);
            maxEnd = Math.max(maxEnd, ebpInfo.offset + dumper.getTypeSize(new TypeIndex(ebpInfo.typeIndex)));
        }
        minStart = Math.max(minStart, 4L);
        long sps = 0L;
        if (minStart < maxEnd) {
            maxEnd = maxEnd + 3L & 0xFFFFFFFFFFFFFFFCL;
            sps = maxEnd - minStart;
        }
        this.parameterSize = sps;
        return sps;
    }

    public void updatePrivate(ProcedureSymbol function, BlockInfo blockInfo, SourceLineCollector lineCollector) {
        this.isMultiple = true;
        String funName = function.getName();
        if (funName.compareTo(this.name) < 0) {
            this.name = funName;
            this.typeIndex = function.getTypeIndex();
            this.offset = blockInfo.getOffset();
            this.len = blockInfo.getLen();
            this.source = lineCollector.collectSourceLines(blockInfo.getOffset(), blockInfo.getLen());
        }
    }

    public void updatePublic(PublicSymbol symbol) {
        if (this.isPublic) {
            this.isMultiple = true;
            String symName = symbol.getName();
            if (symName.compareTo(this.name) < 0) {
                this.name = symName;
                this.offset = symbol.getOffset();
            }
        } else {
            PFuncName pFuncName;
            String name;
            PdbInternalSectionOffset symOffset;
            String funcName = symbol.getName();
            if (this.typeIndex == 0L && (symOffset = this.symOffset) != null && symOffset.isEq(symbol.getOffset())) {
                this.name = funcName;
            }
            if ((name = (pFuncName = PFuncName.getUnknown(funcName)).getUnknown().getName()).equals(this.name) || funcName.equals(this.name)) {
                this.name = name;
                this.parameterSize = pFuncName.getUnknown().getParamSize();
            }
        }
    }

    public Pair<PDBSymbol, PdbInternalSectionOffset> mvToPdbSymbol(TypeDumper dumper, long rva, AddressMap addressMap, FrameTable frameTable) {
        long stackParamSize;
        String name;
        PFuncName pFuncName;
        if (rva == 99008L) {
            boolean bl = true;
        }
        if ((pFuncName = this.getUnd(dumper)).getUndecorated() != null && pFuncName.getUndecorated().getName().equals("std::basic_string<wchar_t,std::char_traits<wchar_t>,std::allocator<wchar_t> >::_Assign_rv(std::basic_string<wchar_t,std::char_traits<wchar_t>,std::allocator<wchar_t> > )")) {
            boolean bl = true;
        }
        if (pFuncName.getUndecorated() != null) {
            name = pFuncName.getUndecorated().getName();
            stackParamSize = this.getStackParamSize(dumper, addressMap, frameTable);
        } else {
            name = pFuncName.getUnknown().getName();
            stackParamSize = pFuncName.getUnknown().getParamSize();
        }
        this.source.finalize(rva, this.len, addressMap);
        PDBSymbol pdbSymbol = new PDBSymbol(name, this.isPublic, this.isMultiple, 0L, this.len, stackParamSize, this.source, this.id);
        return new ImmutablePair<PDBSymbol, PdbInternalSectionOffset>(pdbSymbol, this.offset);
    }

    public String getName() {
        return this.name;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public PdbInternalSectionOffset getSymOffset() {
        return this.symOffset;
    }

    public long getLen() {
        return this.len;
    }

    public long getParameterSize() {
        return this.parameterSize;
    }

    public Lines getSource() {
        return this.source;
    }

    public List<EBPInfo> getEbp() {
        return this.ebp;
    }

    public long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTypeIndex(long typeIndex) {
        this.typeIndex = typeIndex;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setSymOffset(PdbInternalSectionOffset symOffset) {
        this.symOffset = symOffset;
    }

    public void setLen(long len) {
        this.len = len;
    }

    public void setParameterSize(long parameterSize) {
        this.parameterSize = parameterSize;
    }

    public void setSource(Lines source2) {
        this.source = source2;
    }

    public void setEbp(List<EBPInfo> ebp) {
        this.ebp = ebp;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectedSymbol)) {
            return false;
        }
        SelectedSymbol other = (SelectedSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTypeIndex() != other.getTypeIndex()) {
            return false;
        }
        if (this.isPublic() != other.isPublic()) {
            return false;
        }
        if (this.isMultiple() != other.isMultiple()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        if (this.getParameterSize() != other.getParameterSize()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        PdbInternalSectionOffset this$symOffset = this.getSymOffset();
        PdbInternalSectionOffset other$symOffset = other.getSymOffset();
        if (this$symOffset == null ? other$symOffset != null : !((Object)this$symOffset).equals(other$symOffset)) {
            return false;
        }
        Lines this$source = this.getSource();
        Lines other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        List<EBPInfo> this$ebp = this.getEbp();
        List<EBPInfo> other$ebp = other.getEbp();
        return !(this$ebp == null ? other$ebp != null : !((Object)this$ebp).equals(other$ebp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelectedSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $typeIndex = this.getTypeIndex();
        result = result * 59 + (int)($typeIndex >>> 32 ^ $typeIndex);
        result = result * 59 + (this.isPublic() ? 79 : 97);
        result = result * 59 + (this.isMultiple() ? 79 : 97);
        long $len = this.getLen();
        result = result * 59 + (int)($len >>> 32 ^ $len);
        long $parameterSize = this.getParameterSize();
        result = result * 59 + (int)($parameterSize >>> 32 ^ $parameterSize);
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        PdbInternalSectionOffset $symOffset = this.getSymOffset();
        result = result * 59 + ($symOffset == null ? 43 : ((Object)$symOffset).hashCode());
        Lines $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        List<EBPInfo> $ebp = this.getEbp();
        result = result * 59 + ($ebp == null ? 43 : ((Object)$ebp).hashCode());
        return result;
    }

    public String toString() {
        return "SelectedSymbol(name=" + this.getName() + ", typeIndex=" + this.getTypeIndex() + ", isPublic=" + this.isPublic() + ", isMultiple=" + this.isMultiple() + ", offset=" + this.getOffset() + ", symOffset=" + this.getSymOffset() + ", len=" + this.getLen() + ", parameterSize=" + this.getParameterSize() + ", source=" + this.getSource() + ", ebp=" + this.getEbp() + ", id=" + this.getId() + ")";
    }
}

