/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.PDBContributions;
import com.uqm.crashsight.symtabtool.pdb.PDBSections;
import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.framedata.FrameTable;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceLineCollector;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;
import com.uqm.crashsight.symtabtool.pdb.omap.RvaRangeIter;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.EBPInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbols;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PublicSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.RegisterRelativeSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SelectedSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolKey;
import com.uqm.crashsight.symtabtool.pdb.types.TypeDumper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RvaSymbols {
    Map<Long, SelectedSymbol> map;
    long rva;
    SelectedSymbol symbol;
    long lastId;

    public static RvaSymbols empty() {
        RvaSymbols self = new RvaSymbols();
        self.map = new HashMap<Long, SelectedSymbol>(0);
        self.rva = 0L;
        self.symbol = null;
        self.lastId = 0L;
        return self;
    }

    public void addPublicSymbol(PublicSymbol symbol, PDBSections pdbSections, PDBContributions pdbContributions, AddressMap addressMap) {
        Rva rva = symbol.getOffset().toRva(addressMap);
        if (rva == null || rva.isNone()) {
            return;
        }
        if (symbol.isCode() || symbol.isFunction() || pdbSections.isCode(symbol.getOffset().getSection()) && pdbContributions.isCode(symbol.getOffset().getSection(), symbol.getOffset().getOffset())) {
            String symName = symbol.getName();
            if (this.filterPublic(symName)) {
                return;
            }
            SelectedSymbol selected = this.map.getOrDefault(rva.getAddress(), null);
            if (selected != null) {
                selected.updatePublic(symbol);
            } else {
                PdbInternalSectionOffset offset = symbol.getOffset();
                SelectedSymbol symbol1 = new SelectedSymbol(symName, 0L, true, false, offset, null, 0L, 0L, new Lines(), new ArrayList<EBPInfo>(0), this.lastId);
                this.map.put(rva.getAddress(), symbol1);
                ++this.lastId;
            }
        }
    }

    public void addProcedureSymbol(SourceLineCollector lineCollector, ProcedureSymbol function, BlockInfo blockInfo) {
        String funcName = function.getName();
        SelectedSymbol selectedSymbol = this.map.get(blockInfo.getRva());
        if (selectedSymbol != null) {
            selectedSymbol.updatePrivate(function, blockInfo, lineCollector);
        } else {
            Lines source2 = lineCollector.collectSourceLines(blockInfo.getOffset(), blockInfo.getLen());
            this.rva = blockInfo.getRva();
            this.symbol = new SelectedSymbol(funcName, function.getTypeIndex(), false, false, blockInfo.getOffset(), function.getOffset(), blockInfo.getLen(), 0L, source2, new ArrayList<EBPInfo>(), this.lastId);
            ++this.lastId;
        }
    }

    public SelectedSymbol getSymbolAt(long rva) {
        return this.map.get(rva);
    }

    public void addSymbol(SelectedSymbol function, BlockInfo blockInfo) {
        SelectedSymbol selected = this.map.getOrDefault(blockInfo.getRva(), null);
        if (selected != null) {
            selected.isMultiple = true;
        } else {
            this.map.put(blockInfo.getRva(), function);
        }
    }

    public void addEbp(RegisterRelativeSymbol ebp) {
        if (this.symbol != null) {
            this.symbol.ebp.add(new EBPInfo(ebp.getTypeIndex(), ebp.getOffset()));
        }
    }

    public void closeProcedure() {
        if (this.symbol != null) {
            this.map.put(this.rva, this.symbol);
        }
    }

    public Pair<List<PDBSymbol>, Map<SymbolKey, Long>> splitAndCollect(TypeDumper dumper, AddressMap addressMap, FrameTable frameTable) {
        TreeMap<SymbolKey, Long> ranges = new TreeMap<SymbolKey, Long>(Comparator.comparingLong(o -> o.rva));
        ArrayList<PDBSymbol> allSyms = new ArrayList<PDBSymbol>(this.map.size());
        for (Map.Entry<Long, SelectedSymbol> entry : this.map.entrySet()) {
            long rva = entry.getKey();
            SelectedSymbol selectedSymbol = entry.getValue();
            if (selectedSymbol.offset.getOffset() == 95248L) {
                Log.info("break", new Object[0]);
            }
            Pair<PDBSymbol, PdbInternalSectionOffset> pair = selectedSymbol.mvToPdbSymbol(dumper, rva, addressMap, frameTable);
            PDBSymbol sym = pair.getKey();
            PdbInternalSectionOffset offset = pair.getValue();
            long last = allSyms.size();
            if (sym.len == 0L) {
                ranges.put(new SymbolKey(rva, 0L), last);
            } else {
                Range<Long> r;
                PdbInternalRva start = offset.toInternalRva(addressMap);
                PdbInternalRva end = new PdbInternalRva(start.getAddress() + sym.len);
                RvaRangeIter rvaRangeIter = addressMap.rvaRanges(Range.between(start.getAddress(), end.getAddress()));
                while ((r = rvaRangeIter.next()) != null) {
                    ranges.put(new SymbolKey(r.getMinimum(), r.getMaximum() - r.getMinimum()), last);
                }
            }
            allSyms.add(sym);
        }
        return new ImmutablePair<List<PDBSymbol>, Map<SymbolKey, Long>>(allSyms, ranges);
    }

    public PDBSymbols fillTheGaps(List<PDBSymbol> allSyms, Map<SymbolKey, Long> ranges) {
        TreeMap<Long, PDBSymbol> syms = PDBSymbols.empty().map;
        int i = 0;
        long lastRva = 0L;
        long lastLen = 0L;
        PDBSymbol lastSym = null;
        long lastId = 0L;
        for (Map.Entry<SymbolKey, Long> entry : ranges.entrySet()) {
            long sysPos = entry.getValue();
            long rva = entry.getKey().rva;
            long len = entry.getKey().len;
            if (i == 0) {
                lastRva = rva;
                lastLen = len;
                lastSym = allSyms.get((int)sysPos);
                lastId = lastSym.id;
            } else {
                PDBSymbol sym = allSyms.get((int)sysPos);
                if (lastId == sym.id) {
                    lastLen = rva - lastRva + len;
                } else {
                    syms.put(lastRva, lastSym.getFrom(lastRva, lastLen));
                    lastSym = sym;
                    lastId = sym.id;
                    lastRva = rva;
                    lastLen = len;
                }
            }
            ++i;
        }
        if (lastSym != null) {
            syms.put(lastRva, lastSym.getFrom(lastRva, lastLen));
        }
        return new PDBSymbols(syms);
    }

    public boolean isConstantString(String name) {
        return name != null && name.startsWith("??_C");
    }

    public boolean isConstantNumber(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("__")) {
            return (name = name.replaceFirst("__", "")).startsWith("real@") || name.startsWith("xmm@") || name.startsWith("ymm@");
        }
        return false;
    }

    public boolean filterPublic(String name) {
        return this.isConstantString(name) || this.isConstantNumber(name);
    }

    public PDBSymbols moveToPdbSymbols(TypeDumper dumper, AddressMap addressMap, FrameTable frameTable) {
        if (this.map.isEmpty()) {
            return PDBSymbols.empty();
        }
        Pair<List<PDBSymbol>, Map<SymbolKey, Long>> pair = this.splitAndCollect(dumper, addressMap, frameTable);
        return this.fillTheGaps(pair.getLeft(), pair.getRight());
    }
}

