/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class RegisterRelativeSymbol {
    int offset;
    long typeIndex;
    int register;
    String name;

    public static RegisterRelativeSymbol parse(ParseBuffer buffer, int kind) {
        try {
            RegisterRelativeSymbol symbol = new RegisterRelativeSymbol();
            symbol.offset = buffer.readI32();
            symbol.typeIndex = buffer.readU32();
            symbol.register = buffer.readU16();
            symbol.name = Utils.parseSymbolName(buffer, kind);
            return symbol;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public int getRegister() {
        return this.register;
    }

    public String getName() {
        return this.name;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setTypeIndex(long typeIndex) {
        this.typeIndex = typeIndex;
    }

    public void setRegister(int register) {
        this.register = register;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterRelativeSymbol)) {
            return false;
        }
        RegisterRelativeSymbol other = (RegisterRelativeSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getTypeIndex() != other.getTypeIndex()) {
            return false;
        }
        if (this.getRegister() != other.getRegister()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisterRelativeSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        long $typeIndex = this.getTypeIndex();
        result = result * 59 + (int)($typeIndex >>> 32 ^ $typeIndex);
        result = result * 59 + this.getRegister();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "RegisterRelativeSymbol(offset=" + this.getOffset() + ", typeIndex=" + this.getTypeIndex() + ", register=" + this.getRegister() + ", name=" + this.getName() + ")";
    }
}

