/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class PublicSymbol {
    public static long CVPSF_CODE = 1L;
    public static long CVPSF_FUNCTION = 2L;
    public static long CVPSF_MANAGED = 4L;
    public static long CVPSF_MSIL = 8L;
    boolean code;
    boolean function;
    boolean managed;
    boolean misl;
    PdbInternalSectionOffset offset;
    String name;

    public PublicSymbol(boolean code, boolean function, boolean managed, boolean misl, PdbInternalSectionOffset offset, String name) {
        this.code = code;
        this.function = function;
        this.managed = managed;
        this.misl = misl;
        this.offset = offset;
        if (offset.getSection() == 8) {
            boolean bl = true;
        }
        this.name = name;
    }

    public static PublicSymbol parse(ParseBuffer buffer, int kind) {
        try {
            long flags = buffer.readU32();
            return new PublicSymbol((flags & CVPSF_CODE) != 0L, (flags & CVPSF_FUNCTION) != 0L, (flags & CVPSF_MANAGED) != 0L, (flags & CVPSF_MSIL) != 0L, PdbInternalSectionOffset.parse(buffer), Utils.parseSymbolName(buffer, kind));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isCode() {
        return this.code;
    }

    public boolean isFunction() {
        return this.function;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public boolean isMisl() {
        return this.misl;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(boolean code) {
        this.code = code;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public void setMisl(boolean misl) {
        this.misl = misl;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicSymbol)) {
            return false;
        }
        PublicSymbol other = (PublicSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCode() != other.isCode()) {
            return false;
        }
        if (this.isFunction() != other.isFunction()) {
            return false;
        }
        if (this.isManaged() != other.isManaged()) {
            return false;
        }
        if (this.isMisl() != other.isMisl()) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublicSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCode() ? 79 : 97);
        result = result * 59 + (this.isFunction() ? 79 : 97);
        result = result * 59 + (this.isManaged() ? 79 : 97);
        result = result * 59 + (this.isMisl() ? 79 : 97);
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "PublicSymbol(code=" + this.isCode() + ", function=" + this.isFunction() + ", managed=" + this.isManaged() + ", misl=" + this.isMisl() + ", offset=" + this.getOffset() + ", name=" + this.getName() + ")";
    }
}

