/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureFlags;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ProcedureSymbol {
    private boolean global;
    private boolean dpc;
    private Long parent;
    private long end;
    private Long next;
    private long len;
    private long dbgStartOffset;
    private long dbgEndOffset;
    private long typeIndex;
    private PdbInternalSectionOffset offset;
    private ProcedureFlags flags;
    String name;

    public static ProcedureSymbol parse(ParseBuffer buffer, int kind) {
        try {
            ProcedureSymbol procedureSymbol = new ProcedureSymbol();
            procedureSymbol.setGlobal(kind == 4368 || kind == 4107 || kind == 4423);
            procedureSymbol.setDpc(kind == 4437 || kind == 4438);
            long parent = buffer.readU32();
            procedureSymbol.setParent(parent == 0L ? null : Long.valueOf(parent));
            procedureSymbol.setEnd(buffer.readU32());
            long next = buffer.readU32();
            procedureSymbol.setNext(next == 0L ? null : Long.valueOf(next));
            procedureSymbol.setLen(buffer.readU32());
            procedureSymbol.setDbgStartOffset(buffer.readU32());
            procedureSymbol.setDbgEndOffset(buffer.readU32());
            procedureSymbol.setTypeIndex(buffer.readU32());
            PdbInternalSectionOffset offset = PdbInternalSectionOffset.parse(buffer);
            procedureSymbol.setOffset(offset);
            procedureSymbol.setFlags(ProcedureFlags.parse(buffer));
            procedureSymbol.setName(Utils.parseSymbolName(buffer, kind));
            return procedureSymbol;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isDpc() {
        return this.dpc;
    }

    public Long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public Long getNext() {
        return this.next;
    }

    public long getLen() {
        return this.len;
    }

    public long getDbgStartOffset() {
        return this.dbgStartOffset;
    }

    public long getDbgEndOffset() {
        return this.dbgEndOffset;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public ProcedureFlags getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public void setDpc(boolean dpc) {
        this.dpc = dpc;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setNext(Long next) {
        this.next = next;
    }

    public void setLen(long len) {
        this.len = len;
    }

    public void setDbgStartOffset(long dbgStartOffset) {
        this.dbgStartOffset = dbgStartOffset;
    }

    public void setDbgEndOffset(long dbgEndOffset) {
        this.dbgEndOffset = dbgEndOffset;
    }

    public void setTypeIndex(long typeIndex) {
        this.typeIndex = typeIndex;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setFlags(ProcedureFlags flags) {
        this.flags = flags;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcedureSymbol)) {
            return false;
        }
        ProcedureSymbol other = (ProcedureSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGlobal() != other.isGlobal()) {
            return false;
        }
        if (this.isDpc() != other.isDpc()) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        if (this.getDbgStartOffset() != other.getDbgStartOffset()) {
            return false;
        }
        if (this.getDbgEndOffset() != other.getDbgEndOffset()) {
            return false;
        }
        if (this.getTypeIndex() != other.getTypeIndex()) {
            return false;
        }
        Long this$parent = this.getParent();
        Long other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Long this$next = this.getNext();
        Long other$next = other.getNext();
        if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        ProcedureFlags this$flags = this.getFlags();
        ProcedureFlags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcedureSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobal() ? 79 : 97);
        result = result * 59 + (this.isDpc() ? 79 : 97);
        long $end = this.getEnd();
        result = result * 59 + (int)($end >>> 32 ^ $end);
        long $len = this.getLen();
        result = result * 59 + (int)($len >>> 32 ^ $len);
        long $dbgStartOffset = this.getDbgStartOffset();
        result = result * 59 + (int)($dbgStartOffset >>> 32 ^ $dbgStartOffset);
        long $dbgEndOffset = this.getDbgEndOffset();
        result = result * 59 + (int)($dbgEndOffset >>> 32 ^ $dbgEndOffset);
        long $typeIndex = this.getTypeIndex();
        result = result * 59 + (int)($typeIndex >>> 32 ^ $typeIndex);
        Long $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Long $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        ProcedureFlags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ProcedureSymbol(global=" + this.isGlobal() + ", dpc=" + this.isDpc() + ", parent=" + this.getParent() + ", end=" + this.getEnd() + ", next=" + this.getNext() + ", len=" + this.getLen() + ", dbgStartOffset=" + this.getDbgStartOffset() + ", dbgEndOffset=" + this.getDbgEndOffset() + ", typeIndex=" + this.getTypeIndex() + ", offset=" + this.getOffset() + ", flags=" + this.getFlags() + ", name=" + this.getName() + ")";
    }
}

