/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ProcedureReferenceSymbol {
    boolean global;
    long sumName;
    long symbolIndex;
    int module;
    String name;

    public ProcedureReferenceSymbol(boolean global, long sumName, long symbolIndex, int module, String name) {
        this.global = global;
        this.sumName = sumName;
        this.symbolIndex = symbolIndex;
        this.module = module;
        this.name = name;
    }

    public static ProcedureReferenceSymbol parse(ParseBuffer buffer, int kind) {
        try {
            return new ProcedureReferenceSymbol(kind == 4389 || kind == 1024, buffer.readU32(), buffer.readU32(), buffer.readU16(), Utils.parseSymbolName(buffer, kind));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public long getSumName() {
        return this.sumName;
    }

    public long getSymbolIndex() {
        return this.symbolIndex;
    }

    public int getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public void setSumName(long sumName) {
        this.sumName = sumName;
    }

    public void setSymbolIndex(long symbolIndex) {
        this.symbolIndex = symbolIndex;
    }

    public void setModule(int module) {
        this.module = module;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcedureReferenceSymbol)) {
            return false;
        }
        ProcedureReferenceSymbol other = (ProcedureReferenceSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGlobal() != other.isGlobal()) {
            return false;
        }
        if (this.getSumName() != other.getSumName()) {
            return false;
        }
        if (this.getSymbolIndex() != other.getSymbolIndex()) {
            return false;
        }
        if (this.getModule() != other.getModule()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcedureReferenceSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobal() ? 79 : 97);
        long $sumName = this.getSumName();
        result = result * 59 + (int)($sumName >>> 32 ^ $sumName);
        long $symbolIndex = this.getSymbolIndex();
        result = result * 59 + (int)($symbolIndex >>> 32 ^ $symbolIndex);
        result = result * 59 + this.getModule();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ProcedureReferenceSymbol(global=" + this.isGlobal() + ", sumName=" + this.getSumName() + ", symbolIndex=" + this.getSymbolIndex() + ", module=" + this.getModule() + ", name=" + this.getName() + ")";
    }
}

