/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolData;
import java.util.Arrays;

public class PSymbol {
    private long symbolIndex;
    private byte[] data;
    ParseBuffer buffer;

    public PSymbol(long symbolIndex, byte[] data) {
        this.symbolIndex = symbolIndex;
        this.data = data;
        this.buffer = new ParseBuffer(data);
    }

    public int getRawKind() {
        if (this.data.length < 2) {
            Log.error("getRawKind: data length too short", new Object[0]);
            return 0;
        }
        return this.buffer.getU16();
    }

    public SymbolData parse() {
        return SymbolData.parse(this.buffer);
    }

    public long getSymbolIndex() {
        return this.symbolIndex;
    }

    public byte[] getData() {
        return this.data;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public void setSymbolIndex(long symbolIndex) {
        this.symbolIndex = symbolIndex;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setBuffer(ParseBuffer buffer) {
        this.buffer = buffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PSymbol)) {
            return false;
        }
        PSymbol other = (PSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSymbolIndex() != other.getSymbolIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        ParseBuffer this$buffer = this.getBuffer();
        ParseBuffer other$buffer = other.getBuffer();
        return !(this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $symbolIndex = this.getSymbolIndex();
        result = result * 59 + (int)($symbolIndex >>> 32 ^ $symbolIndex);
        result = result * 59 + Arrays.hashCode(this.getData());
        ParseBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        return result;
    }

    public String toString() {
        return "PSymbol(symbolIndex=" + this.getSymbolIndex() + ", data=" + Arrays.toString(this.getData()) + ", buffer=" + this.getBuffer() + ")";
    }
}

