/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import java.io.BufferedWriter;

public class PDBSymbol {
    String name;
    boolean isPublic;
    boolean isMultiple;
    long rva;
    long len;
    long parameterSize;
    Lines source;
    long id;

    public PDBSymbol(String name, boolean isPublic, boolean isMultiple, long rva, long len, long parameterSize, Lines source2, long id) {
        this.name = name;
        this.isPublic = isPublic;
        this.isMultiple = isMultiple;
        this.rva = rva;
        this.len = len;
        this.parameterSize = parameterSize;
        this.source = source2;
        this.id = id;
        if (rva == 13072L) {
            boolean bl = true;
        }
    }

    public PDBSymbol getFrom(long rva, long len) {
        Lines lines = this.source.retain(rva, len);
        if (lines == null) {
            lines = this.source;
        }
        return new PDBSymbol(this.name, this.isPublic, this.isMultiple, rva, len, this.parameterSize, lines, this.id);
    }

    public void display(BufferedWriter bufferedWriter) {
        try {
            if (this.isPublic) {
                bufferedWriter.write(String.format("PUBLIC %s%x %x %s\n", this.isMultiple ? "m " : "", this.rva, this.parameterSize, this.name));
            } else {
                bufferedWriter.write(String.format("FUNC %s%x %x %x %s\n", this.isMultiple ? "m " : "", this.rva, this.len, this.parameterSize, this.name));
                if (this.source == null) {
                    return;
                }
                this.source.display(bufferedWriter);
            }
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public long getRva() {
        return this.rva;
    }

    public long getLen() {
        return this.len;
    }

    public long getParameterSize() {
        return this.parameterSize;
    }

    public Lines getSource() {
        return this.source;
    }

    public long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public void setRva(long rva) {
        this.rva = rva;
    }

    public void setLen(long len) {
        this.len = len;
    }

    public void setParameterSize(long parameterSize) {
        this.parameterSize = parameterSize;
    }

    public void setSource(Lines source2) {
        this.source = source2;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PDBSymbol)) {
            return false;
        }
        PDBSymbol other = (PDBSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPublic() != other.isPublic()) {
            return false;
        }
        if (this.isMultiple() != other.isMultiple()) {
            return false;
        }
        if (this.getRva() != other.getRva()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        if (this.getParameterSize() != other.getParameterSize()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Lines this$source = this.getSource();
        Lines other$source = other.getSource();
        return !(this$source == null ? other$source != null : !((Object)this$source).equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PDBSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPublic() ? 79 : 97);
        result = result * 59 + (this.isMultiple() ? 79 : 97);
        long $rva = this.getRva();
        result = result * 59 + (int)($rva >>> 32 ^ $rva);
        long $len = this.getLen();
        result = result * 59 + (int)($len >>> 32 ^ $len);
        long $parameterSize = this.getParameterSize();
        result = result * 59 + (int)($parameterSize >>> 32 ^ $parameterSize);
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Lines $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        return result;
    }

    public String toString() {
        return "PDBSymbol(name=" + this.getName() + ", isPublic=" + this.isPublic() + ", isMultiple=" + this.isMultiple() + ", rva=" + this.getRva() + ", len=" + this.getLen() + ", parameterSize=" + this.getParameterSize() + ", source=" + this.getSource() + ", id=" + this.getId() + ")";
    }
}

