/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;
import java.util.ArrayList;
import java.util.List;

public class MultiRegisterVariableSymbol {
    private long typeIndex;
    private List<RegisterVariable> registers;

    public MultiRegisterVariableSymbol(long typeIndex, List<RegisterVariable> registers) {
        this.typeIndex = typeIndex;
        this.registers = registers;
    }

    public static MultiRegisterVariableSymbol parse(ParseBuffer buffer, int kind) {
        try {
            long typeIndex = buffer.readU32();
            int count = kind == 4375 || kind == 4116 ? buffer.readU16() : (int)buffer.readU8();
            ArrayList<RegisterVariable> registers = new ArrayList<RegisterVariable>(count);
            for (int i = 0; i < count; ++i) {
                registers.add(RegisterVariable.parse(buffer, kind));
            }
            return new MultiRegisterVariableSymbol(typeIndex, registers);
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public List<RegisterVariable> getRegisters() {
        return this.registers;
    }

    public void setTypeIndex(long typeIndex) {
        this.typeIndex = typeIndex;
    }

    public void setRegisters(List<RegisterVariable> registers) {
        this.registers = registers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiRegisterVariableSymbol)) {
            return false;
        }
        MultiRegisterVariableSymbol other = (MultiRegisterVariableSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTypeIndex() != other.getTypeIndex()) {
            return false;
        }
        List<RegisterVariable> this$registers = this.getRegisters();
        List<RegisterVariable> other$registers = other.getRegisters();
        return !(this$registers == null ? other$registers != null : !((Object)this$registers).equals(other$registers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiRegisterVariableSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $typeIndex = this.getTypeIndex();
        result = result * 59 + (int)($typeIndex >>> 32 ^ $typeIndex);
        List<RegisterVariable> $registers = this.getRegisters();
        result = result * 59 + ($registers == null ? 43 : ((Object)$registers).hashCode());
        return result;
    }

    public String toString() {
        return "MultiRegisterVariableSymbol(typeIndex=" + this.getTypeIndex() + ", registers=" + this.getRegisters() + ")";
    }

    static class RegisterVariable {
        int register;
        String name;

        public RegisterVariable(int register, String name) {
            this.register = register;
            this.name = name;
        }

        public static RegisterVariable parse(ParseBuffer buffer, int kind) {
            return new RegisterVariable(buffer.readU16(), Utils.parseSymbolName(buffer, kind));
        }
    }
}

