/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;
import com.uqm.crashsight.symtabtool.pdb.symbol.annotations.BinaryAnnotations;

public class InlineSiteSymbol {
    Long parent;
    long end;
    long inlinee;
    Long invocations;
    BinaryAnnotations annotations;

    public InlineSiteSymbol(Long parent, long end, long inlinee, Long invocations, BinaryAnnotations annotations) {
        this.parent = parent;
        this.end = end;
        this.inlinee = inlinee;
        this.invocations = invocations;
        this.annotations = annotations;
    }

    public static InlineSiteSymbol parse(ParseBuffer buffer, int kind) {
        try {
            return new InlineSiteSymbol(Utils.parseOptionalIndex(buffer), buffer.readU32(), buffer.readU32(), kind == 4445 ? Long.valueOf(buffer.readU32()) : null, new BinaryAnnotations(buffer.readBytes(buffer.len())));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public long getInlinee() {
        return this.inlinee;
    }

    public Long getInvocations() {
        return this.invocations;
    }

    public BinaryAnnotations getAnnotations() {
        return this.annotations;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setInlinee(long inlinee) {
        this.inlinee = inlinee;
    }

    public void setInvocations(Long invocations) {
        this.invocations = invocations;
    }

    public void setAnnotations(BinaryAnnotations annotations) {
        this.annotations = annotations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineSiteSymbol)) {
            return false;
        }
        InlineSiteSymbol other = (InlineSiteSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        if (this.getInlinee() != other.getInlinee()) {
            return false;
        }
        Long this$parent = this.getParent();
        Long other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Long this$invocations = this.getInvocations();
        Long other$invocations = other.getInvocations();
        if (this$invocations == null ? other$invocations != null : !((Object)this$invocations).equals(other$invocations)) {
            return false;
        }
        BinaryAnnotations this$annotations = this.getAnnotations();
        BinaryAnnotations other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineSiteSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $end = this.getEnd();
        result = result * 59 + (int)($end >>> 32 ^ $end);
        long $inlinee = this.getInlinee();
        result = result * 59 + (int)($inlinee >>> 32 ^ $inlinee);
        Long $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Long $invocations = this.getInvocations();
        result = result * 59 + ($invocations == null ? 43 : ((Object)$invocations).hashCode());
        BinaryAnnotations $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    public String toString() {
        return "InlineSiteSymbol(parent=" + this.getParent() + ", end=" + this.getEnd() + ", inlinee=" + this.getInlinee() + ", invocations=" + this.getInvocations() + ", annotations=" + this.getAnnotations() + ")";
    }
}

