/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.ExportSymbolFlags;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ExportSymbol {
    int ordinal;
    ExportSymbolFlags flags;
    String name;

    public ExportSymbol(int ordinal, ExportSymbolFlags flags, String name) {
        this.ordinal = ordinal;
        this.flags = flags;
        this.name = name;
    }

    public static ExportSymbol parse(ParseBuffer buffer, int kind) {
        try {
            return new ExportSymbol(buffer.readU16(), ExportSymbolFlags.parse(buffer), Utils.parseSymbolName(buffer, kind));
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public ExportSymbolFlags getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public void setFlags(ExportSymbolFlags flags) {
        this.flags = flags;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportSymbol)) {
            return false;
        }
        ExportSymbol other = (ExportSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrdinal() != other.getOrdinal()) {
            return false;
        }
        ExportSymbolFlags this$flags = this.getFlags();
        ExportSymbolFlags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrdinal();
        ExportSymbolFlags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ExportSymbol(ordinal=" + this.getOrdinal() + ", flags=" + this.getFlags() + ", name=" + this.getName() + ")";
    }
}

