/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class DataSymbol {
    boolean global;
    boolean managed;
    long typeIndex;
    PdbInternalSectionOffset offset;
    String name;

    public DataSymbol(boolean global, boolean managed, long typeIndex, PdbInternalSectionOffset offset, String name) {
        this.global = global;
        this.managed = managed;
        this.typeIndex = typeIndex;
        this.offset = offset;
        this.name = name;
    }

    public static DataSymbol parse(ParseBuffer buffer, int kind) {
        try {
            return new DataSymbol(kind == 4365 || kind == 4104 || kind == 4381 || kind == 4129, kind == 4380 || kind == 4128 || kind == 4381 || kind == 4129, buffer.readU32(), PdbInternalSectionOffset.parse(buffer), Utils.parseSymbolName(buffer, kind));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public void setTypeIndex(long typeIndex) {
        this.typeIndex = typeIndex;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSymbol)) {
            return false;
        }
        DataSymbol other = (DataSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGlobal() != other.isGlobal()) {
            return false;
        }
        if (this.isManaged() != other.isManaged()) {
            return false;
        }
        if (this.getTypeIndex() != other.getTypeIndex()) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobal() ? 79 : 97);
        result = result * 59 + (this.isManaged() ? 79 : 97);
        long $typeIndex = this.getTypeIndex();
        result = result * 59 + (int)($typeIndex >>> 32 ^ $typeIndex);
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "DataSymbol(global=" + this.isGlobal() + ", managed=" + this.isManaged() + ", typeIndex=" + this.getTypeIndex() + ", offset=" + this.getOffset() + ", name=" + this.getName() + ")";
    }
}

