/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class DataReferenceSymbol {
    long sumName;
    long symbolIndex;
    int module;
    String name;

    public DataReferenceSymbol(long sumName, long symbolIndex, int module, String name) {
        this.sumName = sumName;
        this.symbolIndex = symbolIndex;
        this.module = module;
        this.name = name;
    }

    public static DataReferenceSymbol parse(ParseBuffer buffer, int kind) {
        try {
            return new DataReferenceSymbol(buffer.readU32(), buffer.readU32(), buffer.readU16(), Utils.parseSymbolName(buffer, kind));
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getSumName() {
        return this.sumName;
    }

    public long getSymbolIndex() {
        return this.symbolIndex;
    }

    public int getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public void setSumName(long sumName) {
        this.sumName = sumName;
    }

    public void setSymbolIndex(long symbolIndex) {
        this.symbolIndex = symbolIndex;
    }

    public void setModule(int module) {
        this.module = module;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataReferenceSymbol)) {
            return false;
        }
        DataReferenceSymbol other = (DataReferenceSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSumName() != other.getSumName()) {
            return false;
        }
        if (this.getSymbolIndex() != other.getSymbolIndex()) {
            return false;
        }
        if (this.getModule() != other.getModule()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataReferenceSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sumName = this.getSumName();
        result = result * 59 + (int)($sumName >>> 32 ^ $sumName);
        long $symbolIndex = this.getSymbolIndex();
        result = result * 59 + (int)($symbolIndex >>> 32 ^ $symbolIndex);
        result = result * 59 + this.getModule();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "DataReferenceSymbol(sumName=" + this.getSumName() + ", symbolIndex=" + this.getSymbolIndex() + ", module=" + this.getModule() + ", name=" + this.getName() + ")";
    }
}

