/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.Variant;
import com.uqm.crashsight.symtabtool.pdb.common.VariantEnum;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ConstantSymbol {
    private boolean managed;
    private long typeIndex;
    private Variant variant;
    private String name;

    public ConstantSymbol(boolean managed, long typeIndex, Variant variant, String name) {
        this.managed = managed;
        this.typeIndex = typeIndex;
        this.variant = variant;
        this.name = name;
    }

    public static ConstantSymbol parse(ParseBuffer buffer, int kind) {
        try {
            return new ConstantSymbol(kind == 4397, buffer.readU32(), new Variant(VariantEnum.class).parse(buffer), Utils.parseSymbolName(buffer, kind));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isManaged() {
        return this.managed;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public String getName() {
        return this.name;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public void setTypeIndex(long typeIndex) {
        this.typeIndex = typeIndex;
    }

    public void setVariant(Variant variant) {
        this.variant = variant;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstantSymbol)) {
            return false;
        }
        ConstantSymbol other = (ConstantSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isManaged() != other.isManaged()) {
            return false;
        }
        if (this.getTypeIndex() != other.getTypeIndex()) {
            return false;
        }
        Variant this$variant = this.getVariant();
        Variant other$variant = other.getVariant();
        if (this$variant == null ? other$variant != null : !((Object)this$variant).equals(other$variant)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConstantSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isManaged() ? 79 : 97);
        long $typeIndex = this.getTypeIndex();
        result = result * 59 + (int)($typeIndex >>> 32 ^ $typeIndex);
        Variant $variant = this.getVariant();
        result = result * 59 + ($variant == null ? 43 : ((Object)$variant).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ConstantSymbol(managed=" + this.isManaged() + ", typeIndex=" + this.getTypeIndex() + ", variant=" + this.getVariant() + ", name=" + this.getName() + ")";
    }
}

