/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.CompileFlags;
import com.uqm.crashsight.symtabtool.pdb.symbol.CompilerVersion;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;
import com.uqm.crashsight.symtabtool.pdb.symbol.constant.CPUType;
import com.uqm.crashsight.symtabtool.pdb.symbol.constant.SourceLanguage;

public class CompileFlagsSymbol {
    SourceLanguage language;
    CompileFlags flags;
    CPUType cpuType;
    CompilerVersion frontendVersion;
    CompilerVersion backendVersion;
    String versionString;

    public CompileFlagsSymbol(SourceLanguage language, CompileFlags flags, CPUType cpuType, CompilerVersion frontendVersion, CompilerVersion backendVersion, String versionString) {
        this.language = language;
        this.flags = flags;
        this.cpuType = cpuType;
        this.frontendVersion = frontendVersion;
        this.backendVersion = backendVersion;
        this.versionString = versionString;
    }

    public static CompileFlagsSymbol parse(ParseBuffer buffer, int kind) {
        try {
            boolean hasQfe = kind == 4412;
            return new CompileFlagsSymbol(SourceLanguage.parse(buffer), CompileFlags.parse(buffer, kind), CPUType.parse(buffer), CompilerVersion.parse(buffer, hasQfe), CompilerVersion.parse(buffer, hasQfe), Utils.parseSymbolName(buffer, kind));
        }
        catch (Exception e) {
            return null;
        }
    }

    public SourceLanguage getLanguage() {
        return this.language;
    }

    public CompileFlags getFlags() {
        return this.flags;
    }

    public CPUType getCpuType() {
        return this.cpuType;
    }

    public CompilerVersion getFrontendVersion() {
        return this.frontendVersion;
    }

    public CompilerVersion getBackendVersion() {
        return this.backendVersion;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setLanguage(SourceLanguage language) {
        this.language = language;
    }

    public void setFlags(CompileFlags flags) {
        this.flags = flags;
    }

    public void setCpuType(CPUType cpuType) {
        this.cpuType = cpuType;
    }

    public void setFrontendVersion(CompilerVersion frontendVersion) {
        this.frontendVersion = frontendVersion;
    }

    public void setBackendVersion(CompilerVersion backendVersion) {
        this.backendVersion = backendVersion;
    }

    public void setVersionString(String versionString) {
        this.versionString = versionString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompileFlagsSymbol)) {
            return false;
        }
        CompileFlagsSymbol other = (CompileFlagsSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SourceLanguage this$language = this.getLanguage();
        SourceLanguage other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
            return false;
        }
        CompileFlags this$flags = this.getFlags();
        CompileFlags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        CPUType this$cpuType = this.getCpuType();
        CPUType other$cpuType = other.getCpuType();
        if (this$cpuType == null ? other$cpuType != null : !((Object)((Object)this$cpuType)).equals((Object)other$cpuType)) {
            return false;
        }
        CompilerVersion this$frontendVersion = this.getFrontendVersion();
        CompilerVersion other$frontendVersion = other.getFrontendVersion();
        if (this$frontendVersion == null ? other$frontendVersion != null : !((Object)this$frontendVersion).equals(other$frontendVersion)) {
            return false;
        }
        CompilerVersion this$backendVersion = this.getBackendVersion();
        CompilerVersion other$backendVersion = other.getBackendVersion();
        if (this$backendVersion == null ? other$backendVersion != null : !((Object)this$backendVersion).equals(other$backendVersion)) {
            return false;
        }
        String this$versionString = this.getVersionString();
        String other$versionString = other.getVersionString();
        return !(this$versionString == null ? other$versionString != null : !this$versionString.equals(other$versionString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompileFlagsSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SourceLanguage $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
        CompileFlags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        CPUType $cpuType = this.getCpuType();
        result = result * 59 + ($cpuType == null ? 43 : ((Object)((Object)$cpuType)).hashCode());
        CompilerVersion $frontendVersion = this.getFrontendVersion();
        result = result * 59 + ($frontendVersion == null ? 43 : ((Object)$frontendVersion).hashCode());
        CompilerVersion $backendVersion = this.getBackendVersion();
        result = result * 59 + ($backendVersion == null ? 43 : ((Object)$backendVersion).hashCode());
        String $versionString = this.getVersionString();
        result = result * 59 + ($versionString == null ? 43 : $versionString.hashCode());
        return result;
    }

    public String toString() {
        return "CompileFlagsSymbol(language=" + (Object)((Object)this.getLanguage()) + ", flags=" + this.getFlags() + ", cpuType=" + (Object)((Object)this.getCpuType()) + ", frontendVersion=" + this.getFrontendVersion() + ", backendVersion=" + this.getBackendVersion() + ", versionString=" + this.getVersionString() + ")";
    }
}

