/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class BlockSymbol {
    long parent;
    long end;
    long len;
    PdbInternalSectionOffset offset;
    String name;

    public static BlockSymbol parse(ParseBuffer buffer, int kind) {
        try {
            BlockSymbol blockSymbol = new BlockSymbol();
            blockSymbol.parent = buffer.readU32();
            blockSymbol.end = buffer.readU32();
            blockSymbol.len = buffer.readU32();
            blockSymbol.offset = PdbInternalSectionOffset.parse(buffer);
            blockSymbol.name = Utils.parseSymbolName(buffer, kind);
            return blockSymbol;
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLen() {
        return this.len;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(long parent) {
        this.parent = parent;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setLen(long len) {
        this.len = len;
    }

    public void setOffset(PdbInternalSectionOffset offset) {
        this.offset = offset;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockSymbol)) {
            return false;
        }
        BlockSymbol other = (BlockSymbol)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getParent() != other.getParent()) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        PdbInternalSectionOffset this$offset = this.getOffset();
        PdbInternalSectionOffset other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockSymbol;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $parent = this.getParent();
        result = result * 59 + (int)($parent >>> 32 ^ $parent);
        long $end = this.getEnd();
        result = result * 59 + (int)($end >>> 32 ^ $end);
        long $len = this.getLen();
        result = result * 59 + (int)($len >>> 32 ^ $len);
        PdbInternalSectionOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "BlockSymbol(parent=" + this.getParent() + ", end=" + this.getEnd() + ", len=" + this.getLen() + ", offset=" + this.getOffset() + ", name=" + this.getName() + ")";
    }
}

