/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.strings;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class StringTableHeader {
    public static final long SIZE = 12L;
    long magic;
    long hashVersion;
    long namesSize;

    public static StringTableHeader parse(ParseBuffer buffer) {
        StringTableHeader header = new StringTableHeader();
        header.magic = buffer.readU32();
        header.hashVersion = buffer.readU32();
        header.namesSize = buffer.readU32();
        return header;
    }

    public long nameStart() {
        return 12L;
    }

    public long namesEnd() {
        return this.nameStart() + this.namesSize;
    }

    public long getMagic() {
        return this.magic;
    }

    public long getHashVersion() {
        return this.hashVersion;
    }

    public long getNamesSize() {
        return this.namesSize;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setHashVersion(long hashVersion) {
        this.hashVersion = hashVersion;
    }

    public void setNamesSize(long namesSize) {
        this.namesSize = namesSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringTableHeader)) {
            return false;
        }
        StringTableHeader other = (StringTableHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getHashVersion() != other.getHashVersion()) {
            return false;
        }
        return this.getNamesSize() == other.getNamesSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringTableHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        long $hashVersion = this.getHashVersion();
        result = result * 59 + (int)($hashVersion >>> 32 ^ $hashVersion);
        long $namesSize = this.getNamesSize();
        result = result * 59 + (int)($namesSize >>> 32 ^ $namesSize);
        return result;
    }

    public String toString() {
        return "StringTableHeader(magic=" + this.getMagic() + ", hashVersion=" + this.getHashVersion() + ", namesSize=" + this.getNamesSize() + ")";
    }
}

