/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.strings;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.strings.StringTableHashVersion;
import com.uqm.crashsight.symtabtool.pdb.strings.StringTableHeader;

public class StringTable {
    public static final long PDB_NMT_HDR = 0xEFFEEFFEL;
    StringTableHeader header;
    StringTableHashVersion hashVersion;
    ParseBuffer buffer;

    public static StringTable parse(ParseBuffer buffer) {
        StringTable table = new StringTable();
        StringTableHeader header = StringTableHeader.parse(buffer);
        if (header.magic != 0xEFFEEFFEL) {
            Log.error("Unsupported symbol data format", new Object[0]);
            return null;
        }
        if (buffer.len() < header.namesEnd()) {
            Log.error("UnexpectedEof", new Object[0]);
            return null;
        }
        table.header = header;
        table.hashVersion = StringTableHashVersion.from((int)table.header.hashVersion);
        table.buffer = buffer;
        return table;
    }

    public String get(long offset) {
        if (offset >= this.header.namesSize) {
            Log.error("UnexpectedEof", new Object[0]);
            return null;
        }
        long stringOffset = this.header.nameStart() + offset;
        long pos = this.buffer.pos();
        String file = this.buffer.readCString(stringOffset);
        this.buffer.pos(pos);
        return file;
    }

    public StringTableHeader getHeader() {
        return this.header;
    }

    public StringTableHashVersion getHashVersion() {
        return this.hashVersion;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public void setHeader(StringTableHeader header) {
        this.header = header;
    }

    public void setHashVersion(StringTableHashVersion hashVersion) {
        this.hashVersion = hashVersion;
    }

    public void setBuffer(ParseBuffer buffer) {
        this.buffer = buffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringTable)) {
            return false;
        }
        StringTable other = (StringTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringTableHeader this$header = this.getHeader();
        StringTableHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        StringTableHashVersion this$hashVersion = this.getHashVersion();
        StringTableHashVersion other$hashVersion = other.getHashVersion();
        if (this$hashVersion == null ? other$hashVersion != null : !((Object)((Object)this$hashVersion)).equals((Object)other$hashVersion)) {
            return false;
        }
        ParseBuffer this$buffer = this.getBuffer();
        ParseBuffer other$buffer = other.getBuffer();
        return !(this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringTableHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        StringTableHashVersion $hashVersion = this.getHashVersion();
        result = result * 59 + ($hashVersion == null ? 43 : ((Object)((Object)$hashVersion)).hashCode());
        ParseBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        return result;
    }

    public String toString() {
        return "StringTable(header=" + this.getHeader() + ", hashVersion=" + (Object)((Object)this.getHashVersion()) + ", buffer=" + this.getBuffer() + ")";
    }
}

