/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.stream;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.PdbHeaderParser;
import com.uqm.crashsight.symtabtool.pdb.StreamPair;
import com.uqm.crashsight.symtabtool.pdb.Utils;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class StreamManager {
    public static final int PDB_STREAM = 1;
    public static final int TPI_STREAM = 2;
    public static final int DBI_STREAM = 3;
    public static final int IPI_STREAM = 4;
    public static StreamManager instance = null;
    String filename;
    long pageSize;
    long numPages;
    RandomAccessFile randomAccessFile;
    List<StreamPair> streams;

    public static StreamManager init(String filename) {
        instance = new StreamManager();
        StreamManager.instance.filename = filename;
        instance.init();
        return instance;
    }

    private void init() {
        try {
            long streamSize;
            PdbHeaderParser header = PdbHeaderParser.create(this.filename);
            assert (header != null);
            this.pageSize = header.pageSize;
            this.numPages = header.pagesUsed;
            long directoryPages = StreamManager.getNumPages(header.directorySize, this.pageSize);
            this.randomAccessFile = new RandomAccessFile(this.filename, "r");
            this.randomAccessFile.seek(52L);
            long pointerOfPointerOfDirectories = Utils.readUInt(this.randomAccessFile);
            this.randomAccessFile.seek(pointerOfPointerOfDirectories * this.pageSize);
            ByteBuffer directoryBuffer = ByteBuffer.allocate(Utils.getBufferCapacity(directoryPages * this.pageSize));
            directoryBuffer.order(ByteOrder.LITTLE_ENDIAN);
            ParseBuffer streamTable = new ParseBuffer(directoryBuffer);
            long[] directoryPointers = new long[(int)directoryPages];
            int i = 0;
            while ((long)i < directoryPages) {
                directoryPointers[i] = Utils.readUInt(this.randomAccessFile);
                ++i;
            }
            i = 0;
            while ((long)i < directoryPages) {
                this.randomAccessFile.seek(directoryPointers[i] * this.pageSize);
                this.randomAccessFile.read(directoryBuffer.array(), directoryBuffer.position(), (int)this.pageSize);
                directoryBuffer.position((i + 1) * (int)this.pageSize);
                ++i;
            }
            directoryBuffer.flip();
            long numStreams = streamTable.readU32();
            this.streams = new ArrayList<StreamPair>((int)numStreams);
            int i2 = 0;
            while ((long)i2 < numStreams) {
                streamSize = streamTable.readU32();
                this.streams.add(new StreamPair(streamSize));
                ++i2;
            }
            i2 = 0;
            while ((long)i2 < numStreams) {
                streamSize = this.streams.get((int)i2).size;
                if (streamSize > 0L && streamSize != 0xFFFFFFFFL) {
                    long pages = StreamManager.getNumPages(streamSize, this.pageSize);
                    this.streams.get((int)i2).pageIndices = new ArrayList<Long>((int)pages);
                    int j = 0;
                    while ((long)j < pages) {
                        this.streams.get((int)i2).pageIndices.add(streamTable.readU32());
                        ++j;
                    }
                }
                ++i2;
            }
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public static StreamManager getInstance() {
        assert (instance != null);
        return instance;
    }

    static long getNumPages(long length, long pageSize) {
        long numPages = length / pageSize;
        if (length % pageSize != 0L) {
            ++numPages;
        }
        return numPages;
    }

    public static int getBufferCapacity(long capacity) throws Exception {
        if (capacity > Integer.MAX_VALUE) {
            throw new Exception("ByteBuffer capacity too big!");
        }
        return (int)capacity;
    }

    public ByteBuffer getBuffer(int stream) {
        if (stream < 0 || stream >= this.streams.size()) {
            return null;
        }
        StreamPair pair = this.streams.get(stream);
        return this.getBuffer(pair);
    }

    public ByteBuffer getBuffer(StreamPair pair) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(StreamManager.getBufferCapacity(pair.size));
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < pair.pageIndices.size(); ++i) {
                this.randomAccessFile.seek(pair.pageIndices.get(i) * this.pageSize);
                long size = this.pageSize;
                if (i == pair.pageIndices.size() - 1 && pair.size % this.pageSize != 0L) {
                    size = Math.min(this.pageSize, (long)((int)pair.size) % this.pageSize);
                }
                this.randomAccessFile.read(buffer.array(), buffer.position(), (int)size);
                buffer.position(buffer.position() + (int)size);
            }
            buffer.flip();
            return buffer;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ParseBuffer getParseBuffer(int stream) {
        ByteBuffer buffer = this.getBuffer(stream);
        if (buffer == null) {
            return null;
        }
        return new ParseBuffer(buffer);
    }
}

