/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.stream;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ParseBuffer {
    private static final long FIX_LEB128 = 127L;
    private ByteBuffer buffer;
    private final ByteBuffer tmpBuffer = ByteBuffer.allocate(8);
    private final ByteBuffer tmpBuffer4 = ByteBuffer.allocate(4);
    private final byte[] tmpBytes = new byte[8];
    private final byte[] tmpBytes4 = new byte[4];
    private long ptr = 0L;

    public void addPtr(long len) {
        this.ptr += len;
    }

    public static ParseBuffer empty() {
        ByteBuffer buffer = ByteBuffer.allocate(0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ParseBuffer(buffer);
    }

    public ParseBuffer(byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer = buffer;
    }

    public ParseBuffer(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        this.buffer = buffer;
    }

    public ParseBuffer(ByteBuffer buffer, long start, long end) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        int len = (int)(end - start);
        byte[] newArray = new byte[len];
        System.arraycopy(buffer.array(), (int)start, newArray, 0, len);
        this.buffer = ByteBuffer.wrap(newArray);
    }

    public ParseBuffer copy() {
        return this.copyFrom(0L);
    }

    public ParseBuffer copyRef() {
        ByteBuffer buffer = ByteBuffer.wrap(this.getBuffer().array());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ParseBuffer(buffer);
    }

    public ParseBuffer copyPos() {
        return this.copyFrom(this.pos());
    }

    public ParseBuffer copyFrom(long pos) {
        assert (this.buffer.order() == ByteOrder.LITTLE_ENDIAN);
        int offset = (int)pos;
        byte[] array = this.buffer.array();
        byte[] newArray = new byte[array.length - offset];
        System.arraycopy(array, offset, newArray, 0, newArray.length);
        ByteBuffer buffer = ByteBuffer.wrap(newArray);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ParseBuffer parseBuffer = new ParseBuffer(buffer);
        parseBuffer.ptr = offset;
        return parseBuffer;
    }

    public ParseBuffer copy(long offset, long size) {
        long currentPos = this.pos();
        this.pos(offset);
        byte[] array = this.buffer.array();
        byte[] newArray = new byte[(int)size];
        System.arraycopy(array, (int)offset, newArray, 0, newArray.length);
        ByteBuffer buffer = ByteBuffer.wrap(newArray);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ParseBuffer parseBuffer = new ParseBuffer(buffer);
        parseBuffer.ptr = offset;
        this.pos(currentPos);
        return parseBuffer;
    }

    public ParseBuffer truncate(long len) {
        if ((long)this.buffer.limit() >= len) {
            byte[] newArray = new byte[(int)len];
            System.arraycopy(this.buffer.array(), 0, newArray, 0, newArray.length);
            ByteBuffer buffer = ByteBuffer.wrap(newArray);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return new ParseBuffer(buffer);
        }
        Log.error("UnexpectedEof", new Object[0]);
        return this;
    }

    public ParseBuffer(ByteBuffer buffer, long start) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        int offset = (int)start;
        byte[] array = buffer.array();
        byte[] newArray = new byte[array.length - offset];
        System.arraycopy(array, offset, newArray, 0, newArray.length);
        ByteBuffer newBuffer = ByteBuffer.wrap(newArray);
        newBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer = newBuffer;
    }

    public ParseBuffer take(long size) {
        byte[] newArray = this.readBytes(size);
        ByteBuffer newBuffer = ByteBuffer.wrap(newArray);
        newBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ParseBuffer(newBuffer);
    }

    public ParseBuffer[] splitAt(long pos) {
        ParseBuffer[] parseBuffers = new ParseBuffer[2];
        byte[] array0 = new byte[(int)pos];
        byte[] array1 = new byte[(int)(this.limit() - pos)];
        System.arraycopy(this.buffer.array(), 0, array0, 0, array0.length);
        System.arraycopy(this.buffer.array(), array0.length, array1, 0, array1.length);
        ByteBuffer buffer0 = ByteBuffer.wrap(array0);
        buffer0.order(ByteOrder.LITTLE_ENDIAN);
        parseBuffers[0] = new ParseBuffer(buffer0);
        ByteBuffer buffer1 = ByteBuffer.wrap(array1);
        buffer1.order(ByteOrder.LITTLE_ENDIAN);
        parseBuffers[1] = new ParseBuffer(buffer1);
        return parseBuffers;
    }

    public long pos() {
        return this.buffer.position();
    }

    public void pos(long pos) {
        this.buffer.position((int)pos);
    }

    public long limit() {
        return this.buffer.limit();
    }

    public void start(long pos) {
    }

    public long len() {
        return this.buffer.limit() - this.buffer.position();
    }

    public boolean isEmpty() {
        return this.len() == 0L;
    }

    public long remaining() {
        return this.buffer.remaining();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public void align(long alignment) {
        long diff = this.pos() % alignment;
        if (diff > 0L) {
            if (this.len() < alignment - diff) {
                Log.error("UnexpectedEof", new Object[0]);
            }
            this.pos(this.pos() + (alignment - diff));
        }
    }

    public byte get(long offset) {
        return this.buffer.get((int)offset);
    }

    public byte[] getBytes(long len) {
        byte[] bytes = this.readBytes(len);
        this.pos(this.pos() - len);
        return bytes;
    }

    public byte[] readBytes(long len) {
        byte[] bytes = new byte[(int)len];
        this.buffer.get(bytes);
        return bytes;
    }

    public byte readI8() {
        return this.buffer.get();
    }

    public short readI16() {
        return this.buffer.getShort();
    }

    public short readLeI16() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        short val = this.buffer.getShort();
        this.buffer.order(order);
        return val;
    }

    public short readBeI16() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        short val = this.buffer.getShort();
        this.buffer.order(order);
        return val;
    }

    public int readI32() {
        return this.buffer.getInt();
    }

    public int readLeI32() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int val = this.buffer.getInt();
        this.buffer.order(order);
        return val;
    }

    public int readBeI32() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int val = this.buffer.getInt();
        this.buffer.order(order);
        return val;
    }

    public long readI64() {
        return this.buffer.getLong();
    }

    public long readLeI64() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        long val = this.buffer.getLong();
        this.buffer.order(order);
        return val;
    }

    public long readBeI64() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        long val = this.buffer.getLong();
        this.buffer.order(order);
        return val;
    }

    public short readU8() {
        byte b = this.buffer.get();
        this.tmpBuffer.clear();
        this.tmpBuffer.put((byte)0);
        this.tmpBuffer.put(b);
        this.tmpBuffer.flip();
        return this.tmpBuffer.getShort();
    }

    public short getU8() {
        short value = this.readU8();
        this.pos(this.pos() - 1L);
        return value;
    }

    public int readU16() {
        this.buffer.get(this.tmpBytes, 0, 2);
        this.tmpBuffer.clear();
        this.tmpBuffer.putShort((short)0);
        for (int i = 1; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getInt();
    }

    public int getU16() {
        int v = this.readU16();
        this.pos(this.pos() - 2L);
        return v;
    }

    public int getBeU16() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int v = this.readU16();
        this.pos(this.pos() - 2L);
        this.buffer.order(order);
        return v;
    }

    public int getLeU16() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int v = this.readU16();
        this.pos(this.pos() - 2L);
        this.buffer.order(order);
        return v;
    }

    public long readU32() {
        try {
            this.buffer.get(this.tmpBytes4, 0, 4);
            this.tmpBuffer.clear();
            this.tmpBuffer.putInt(0);
            for (int i = 3; i >= 0; --i) {
                this.tmpBuffer.put(this.tmpBytes4[i]);
            }
            this.tmpBuffer.flip();
        }
        catch (Exception e) {
            boolean bl = false;
        }
        return this.tmpBuffer.getLong();
    }

    public long readU64() {
        this.buffer.get(this.tmpBytes, 0, 8);
        this.tmpBuffer.clear();
        for (int i = 7; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getLong();
    }

    public byte[] readAtPosWithMode(long offset, int length, int mode) {
        byte[] tmpBuffer = new byte[100];
        this.buffer.get(tmpBuffer, new Long(offset).intValue(), length);
        return tmpBuffer;
    }

    public long getU32() {
        long v = this.readU32();
        this.pos(this.pos() - 4L);
        return v;
    }

    public long getLeU32() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        long v = this.readU32();
        this.pos(this.pos() - 4L);
        this.buffer.order(order);
        return v;
    }

    public long getBeU32() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        long v = this.readU32();
        this.pos(this.pos() - 4L);
        this.buffer.order(order);
        return v;
    }

    public long getLeU64() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        long v = this.readI64();
        this.pos(this.pos() - 8L);
        this.buffer.order(order);
        return v;
    }

    public long getBeU64() {
        ByteOrder order = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        long v = this.readI64();
        this.pos(this.pos() - 8L);
        this.buffer.order(order);
        return v;
    }

    public long parseULeb128() {
        byte b;
        long result = 0L;
        long shift = 0L;
        do {
            b = this.buffer.get();
            result |= ((long)b & 0x7FL) << (int)shift;
            shift += 7L;
        } while ((b & 0x80) != 0);
        return result;
    }

    public long parseSLeb128() {
        byte b;
        long result = 0L;
        long shift = 0L;
        boolean negative = false;
        do {
            b = this.buffer.get();
            result |= ((long)b & 0x7FL) << (int)shift;
            shift += 7L;
            boolean bl = negative = (b & 0x40) != 0;
        } while ((b & 0x80) != 0);
        if (negative) {
            result |= -(1L << (int)shift);
        }
        return result;
    }

    public String readCString(long offset) {
        this.pos(offset);
        return this.readCString();
    }

    public boolean checkCString() {
        long pos = this.pos();
        boolean flag = false;
        while (this.buffer.hasRemaining()) {
            if (this.buffer.get() != 0) continue;
            flag = true;
            break;
        }
        this.pos(pos);
        return flag;
    }

    public String readCString() {
        byte b;
        StringBuilder sb = new StringBuilder();
        while ((b = this.buffer.get()) != 0) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    public String readU8PascalStr() {
        int length = this.readU8();
        StringBuilder sb = new StringBuilder(length);
        for (int i = length; i > 0; --i) {
            sb.append((char)this.readI8());
        }
        return sb.toString();
    }

    public int find(byte needle) {
        int i = 0;
        for (byte v : this.buffer.array()) {
            if (v == needle) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getTmpBuffer() {
        return this.tmpBuffer;
    }

    public ByteBuffer getTmpBuffer4() {
        return this.tmpBuffer4;
    }

    public byte[] getTmpBytes() {
        return this.tmpBytes;
    }

    public byte[] getTmpBytes4() {
        return this.tmpBytes4;
    }

    public long getPtr() {
        return this.ptr;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void setPtr(long ptr) {
        this.ptr = ptr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseBuffer)) {
            return false;
        }
        ParseBuffer other = (ParseBuffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPtr() != other.getPtr()) {
            return false;
        }
        ByteBuffer this$buffer = this.getBuffer();
        ByteBuffer other$buffer = other.getBuffer();
        if (this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer)) {
            return false;
        }
        ByteBuffer this$tmpBuffer = this.getTmpBuffer();
        ByteBuffer other$tmpBuffer = other.getTmpBuffer();
        if (this$tmpBuffer == null ? other$tmpBuffer != null : !((Object)this$tmpBuffer).equals(other$tmpBuffer)) {
            return false;
        }
        ByteBuffer this$tmpBuffer4 = this.getTmpBuffer4();
        ByteBuffer other$tmpBuffer4 = other.getTmpBuffer4();
        if (this$tmpBuffer4 == null ? other$tmpBuffer4 != null : !((Object)this$tmpBuffer4).equals(other$tmpBuffer4)) {
            return false;
        }
        if (!Arrays.equals(this.getTmpBytes(), other.getTmpBytes())) {
            return false;
        }
        return Arrays.equals(this.getTmpBytes4(), other.getTmpBytes4());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParseBuffer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ptr = this.getPtr();
        result = result * 59 + (int)($ptr >>> 32 ^ $ptr);
        ByteBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        ByteBuffer $tmpBuffer = this.getTmpBuffer();
        result = result * 59 + ($tmpBuffer == null ? 43 : ((Object)$tmpBuffer).hashCode());
        ByteBuffer $tmpBuffer4 = this.getTmpBuffer4();
        result = result * 59 + ($tmpBuffer4 == null ? 43 : ((Object)$tmpBuffer4).hashCode());
        result = result * 59 + Arrays.hashCode(this.getTmpBytes());
        result = result * 59 + Arrays.hashCode(this.getTmpBytes4());
        return result;
    }

    public String toString() {
        return "ParseBuffer(buffer=" + this.getBuffer() + ", tmpBuffer=" + this.getTmpBuffer() + ", tmpBuffer4=" + this.getTmpBuffer4() + ", tmpBytes=" + Arrays.toString(this.getTmpBytes()) + ", tmpBytes4=" + Arrays.toString(this.getTmpBytes4()) + ", ptr=" + this.getPtr() + ")";
    }
}

