/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.pe;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class ImageSectionHeader {
    byte[] name = new byte[8];
    long physicalAddress;
    long virtualAddress;
    long sizeOfRawData;
    long pointerToRawData;
    long pointerToRelocations;
    long pointerToLineNumbers;
    int numberOfRelocations;
    int numberOfLineNumbers;
    long characteristics;

    public static ImageSectionHeader parse(ParseBuffer parseBuffer) {
        ImageSectionHeader header = new ImageSectionHeader();
        header.name = parseBuffer.readBytes(8L);
        header.physicalAddress = parseBuffer.readU32();
        header.virtualAddress = parseBuffer.readU32();
        header.sizeOfRawData = parseBuffer.readU32();
        header.pointerToRawData = parseBuffer.readU32();
        header.pointerToRelocations = parseBuffer.readU32();
        header.pointerToLineNumbers = parseBuffer.readU32();
        header.numberOfRelocations = parseBuffer.readU16();
        header.numberOfLineNumbers = parseBuffer.readU16();
        header.characteristics = parseBuffer.readU32();
        return header;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.name) {
            if (b == 0) break;
            char c = (char)b;
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean isTextSection() {
        return ".text".equalsIgnoreCase(this.getName());
    }

    public String toString() {
        return "name:" + this.getName() + " PhysicalAddress(VirtualSize):0x" + Long.toString(this.physicalAddress, 16) + " virtualAddress:0x" + Long.toString(this.virtualAddress, 16) + " sizeOfRawData:0x" + Long.toString(this.sizeOfRawData, 16);
    }

    public long getPhysicalAddress() {
        return this.physicalAddress;
    }

    public long getVirtualAddress() {
        return this.virtualAddress;
    }

    public long getSizeOfRawData() {
        return this.sizeOfRawData;
    }

    public long getPointerToRawData() {
        return this.pointerToRawData;
    }

    public long getPointerToRelocations() {
        return this.pointerToRelocations;
    }

    public long getPointerToLineNumbers() {
        return this.pointerToLineNumbers;
    }

    public int getNumberOfRelocations() {
        return this.numberOfRelocations;
    }

    public int getNumberOfLineNumbers() {
        return this.numberOfLineNumbers;
    }

    public long getCharacteristics() {
        return this.characteristics;
    }

    public void setName(byte[] name) {
        this.name = name;
    }

    public void setPhysicalAddress(long physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public void setVirtualAddress(long virtualAddress) {
        this.virtualAddress = virtualAddress;
    }

    public void setSizeOfRawData(long sizeOfRawData) {
        this.sizeOfRawData = sizeOfRawData;
    }

    public void setPointerToRawData(long pointerToRawData) {
        this.pointerToRawData = pointerToRawData;
    }

    public void setPointerToRelocations(long pointerToRelocations) {
        this.pointerToRelocations = pointerToRelocations;
    }

    public void setPointerToLineNumbers(long pointerToLineNumbers) {
        this.pointerToLineNumbers = pointerToLineNumbers;
    }

    public void setNumberOfRelocations(int numberOfRelocations) {
        this.numberOfRelocations = numberOfRelocations;
    }

    public void setNumberOfLineNumbers(int numberOfLineNumbers) {
        this.numberOfLineNumbers = numberOfLineNumbers;
    }

    public void setCharacteristics(long characteristics) {
        this.characteristics = characteristics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageSectionHeader)) {
            return false;
        }
        ImageSectionHeader other = (ImageSectionHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPhysicalAddress() != other.getPhysicalAddress()) {
            return false;
        }
        if (this.getVirtualAddress() != other.getVirtualAddress()) {
            return false;
        }
        if (this.getSizeOfRawData() != other.getSizeOfRawData()) {
            return false;
        }
        if (this.getPointerToRawData() != other.getPointerToRawData()) {
            return false;
        }
        if (this.getPointerToRelocations() != other.getPointerToRelocations()) {
            return false;
        }
        if (this.getPointerToLineNumbers() != other.getPointerToLineNumbers()) {
            return false;
        }
        if (this.getNumberOfRelocations() != other.getNumberOfRelocations()) {
            return false;
        }
        if (this.getNumberOfLineNumbers() != other.getNumberOfLineNumbers()) {
            return false;
        }
        if (this.getCharacteristics() != other.getCharacteristics()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageSectionHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $physicalAddress = this.getPhysicalAddress();
        result = result * 59 + (int)($physicalAddress >>> 32 ^ $physicalAddress);
        long $virtualAddress = this.getVirtualAddress();
        result = result * 59 + (int)($virtualAddress >>> 32 ^ $virtualAddress);
        long $sizeOfRawData = this.getSizeOfRawData();
        result = result * 59 + (int)($sizeOfRawData >>> 32 ^ $sizeOfRawData);
        long $pointerToRawData = this.getPointerToRawData();
        result = result * 59 + (int)($pointerToRawData >>> 32 ^ $pointerToRawData);
        long $pointerToRelocations = this.getPointerToRelocations();
        result = result * 59 + (int)($pointerToRelocations >>> 32 ^ $pointerToRelocations);
        long $pointerToLineNumbers = this.getPointerToLineNumbers();
        result = result * 59 + (int)($pointerToLineNumbers >>> 32 ^ $pointerToLineNumbers);
        result = result * 59 + this.getNumberOfRelocations();
        result = result * 59 + this.getNumberOfLineNumbers();
        long $characteristics = this.getCharacteristics();
        result = result * 59 + (int)($characteristics >>> 32 ^ $characteristics);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

