/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.pdbi;

import com.uqm.crashsight.symtabtool.pdb.dbi.HeaderVersion;
import com.uqm.crashsight.symtabtool.pdb.pdbi.StreamName;
import com.uqm.crashsight.symtabtool.pdb.pdbi.StreamNames;
import com.uqm.crashsight.symtabtool.pdb.pdbi.Uuid;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import java.util.ArrayList;

public class PDBInformation {
    HeaderVersion version;
    long signature;
    long age;
    Uuid guid;
    long namesOffset;
    long namesSize;
    ParseBuffer buffer;

    public static PDBInformation parse(ParseBuffer buffer) {
        PDBInformation self = new PDBInformation();
        self.version = HeaderVersion.fromInt((int)buffer.readU32());
        self.signature = buffer.readU32();
        self.age = buffer.readU32();
        self.guid = Uuid.parse(buffer);
        self.namesSize = buffer.readU32();
        self.namesOffset = buffer.pos();
        self.buffer = buffer;
        return self;
    }

    public StreamNames getStreamNames() {
        ArrayList<StreamName> names = new ArrayList<StreamName>();
        this.buffer.pos((int)(this.namesOffset + this.namesSize));
        long count = this.buffer.readU32();
        long entriesSize = this.buffer.readU32();
        long okWords = this.buffer.readU32();
        byte[] okBits = this.buffer.readBytes(okWords * 4L);
        long deleteWords = this.buffer.readU32();
        byte[] deleteBits = this.buffer.readBytes(deleteWords * 4L);
        ParseBuffer nameReader = new ParseBuffer(this.buffer.getBuffer(), this.namesOffset, this.namesOffset + this.namesSize);
        int i = 0;
        while ((long)i < count) {
            long nameOffset = this.buffer.readU32();
            long streamId = this.buffer.readU32();
            String name = nameReader.readCString(nameOffset);
            names.add(new StreamName(name, (int)streamId));
            ++i;
        }
        return new StreamNames(this.buffer, names);
    }

    public HeaderVersion getVersion() {
        return this.version;
    }

    public long getSignature() {
        return this.signature;
    }

    public long getAge() {
        return this.age;
    }

    public Uuid getGuid() {
        return this.guid;
    }

    public long getNamesOffset() {
        return this.namesOffset;
    }

    public long getNamesSize() {
        return this.namesSize;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public void setVersion(HeaderVersion version) {
        this.version = version;
    }

    public void setSignature(long signature) {
        this.signature = signature;
    }

    public void setAge(long age) {
        this.age = age;
    }

    public void setGuid(Uuid guid) {
        this.guid = guid;
    }

    public void setNamesOffset(long namesOffset) {
        this.namesOffset = namesOffset;
    }

    public void setNamesSize(long namesSize) {
        this.namesSize = namesSize;
    }

    public void setBuffer(ParseBuffer buffer) {
        this.buffer = buffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PDBInformation)) {
            return false;
        }
        PDBInformation other = (PDBInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSignature() != other.getSignature()) {
            return false;
        }
        if (this.getAge() != other.getAge()) {
            return false;
        }
        if (this.getNamesOffset() != other.getNamesOffset()) {
            return false;
        }
        if (this.getNamesSize() != other.getNamesSize()) {
            return false;
        }
        HeaderVersion this$version = this.getVersion();
        HeaderVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version)) {
            return false;
        }
        Uuid this$guid = this.getGuid();
        Uuid other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !((Object)this$guid).equals(other$guid)) {
            return false;
        }
        ParseBuffer this$buffer = this.getBuffer();
        ParseBuffer other$buffer = other.getBuffer();
        return !(this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PDBInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $signature = this.getSignature();
        result = result * 59 + (int)($signature >>> 32 ^ $signature);
        long $age = this.getAge();
        result = result * 59 + (int)($age >>> 32 ^ $age);
        long $namesOffset = this.getNamesOffset();
        result = result * 59 + (int)($namesOffset >>> 32 ^ $namesOffset);
        long $namesSize = this.getNamesSize();
        result = result * 59 + (int)($namesSize >>> 32 ^ $namesSize);
        HeaderVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
        Uuid $guid = this.getGuid();
        result = result * 59 + ($guid == null ? 43 : ((Object)$guid).hashCode());
        ParseBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        return result;
    }

    public String toString() {
        return "PDBInformation(version=" + (Object)((Object)this.getVersion()) + ", signature=" + this.getSignature() + ", age=" + this.getAge() + ", guid=" + this.getGuid() + ", namesOffset=" + this.getNamesOffset() + ", namesSize=" + this.getNamesSize() + ", buffer=" + this.getBuffer() + ")";
    }
}

