/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;

public class SectionOffset {
    long offset;
    int section;

    public SectionOffset(long offset, int source2) {
        this.offset = offset;
        this.section = source2;
    }

    public Rva toRva(AddressMap translator) {
        if (translator.transformedSections != null) {
            return new Rva(AddressMap.getVirtualAddress(translator.transformedSections, this.section, this.offset));
        }
        return new Rva(AddressMap.getVirtualAddress(translator.originalSections, this.section, this.offset));
    }

    public PdbInternalRva toInternalRva(AddressMap translator) {
        return this.toRva(translator).toInternalRva(translator);
    }

    public PdbInternalSectionOffset toInternalOffset(AddressMap translator) {
        if (translator.transformedSections == null) {
            return new PdbInternalSectionOffset(this.offset, this.section);
        }
        return this.toInternalRva(translator).toInternalOffset(translator);
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSection() {
        return this.section;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setSection(int section) {
        this.section = section;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SectionOffset)) {
            return false;
        }
        SectionOffset other = (SectionOffset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.getSection() == other.getSection();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SectionOffset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        result = result * 59 + this.getSection();
        return result;
    }

    public String toString() {
        return "SectionOffset(offset=" + this.getOffset() + ", section=" + this.getSection() + ")";
    }
}

