/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.omap.SectionOffset;

public class Rva {
    Long address;

    public Rva(Long address) {
        this.address = address;
    }

    public boolean isNone() {
        return this.address == null;
    }

    public PdbInternalRva toInternalRva(AddressMap translator) {
        if (translator.transformedToOriginal != null) {
            return new PdbInternalRva(translator.transformedToOriginal.lookup(this.address));
        }
        return new PdbInternalRva(this.address);
    }

    public SectionOffset toSectionOffset(AddressMap translator) {
        if (translator.transformedSections != null) {
            return AddressMap.getSectionOffset(translator.transformedSections, this.address);
        }
        return AddressMap.getSectionOffset(translator.originalSections, this.address);
    }

    public PdbInternalSectionOffset toInternalOffset(AddressMap translator) {
        return this.toInternalRva(translator).toInternalOffset(translator);
    }

    public Long getAddress() {
        return this.address;
    }

    public void setAddress(Long address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rva)) {
            return false;
        }
        Rva other = (Rva)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$address = this.getAddress();
        Long other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rva;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public String toString() {
        return "Rva(address=" + this.getAddress() + ")";
    }
}

