/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.OMAPRecord;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.Range;

public class RangeIter {
    Iterator<OMAPRecord> records;
    OMAPRecord record;
    long addr;
    long end;

    public RangeIter(Iterator<OMAPRecord> records, OMAPRecord record, long addr, long end) {
        this.records = records;
        this.record = record;
        this.addr = addr;
        this.end = end;
    }

    public static RangeIter empty() {
        return new RangeIter(Collections.emptyIterator(), OMAPRecord.empty(), 0L, 0L);
    }

    public static RangeIter identity(Range<Long> range) {
        return new RangeIter(Collections.emptyIterator(), new OMAPRecord(range.getMinimum(), range.getMinimum()), range.getMinimum(), range.getMaximum());
    }

    public static RangeIter _default() {
        return RangeIter.empty();
    }

    public Range<Long> next() {
        while (this.addr < this.end) {
            OMAPRecord nextRecord = this.records.hasNext() ? this.records.next() : new OMAPRecord(this.end, 0L);
            long subrangeEnd = Math.min(nextRecord.getSourceAddress(), this.end);
            long subrangeStart = this.addr;
            this.addr = subrangeEnd;
            OMAPRecord lastRecord = this.record;
            this.record = nextRecord;
            if (subrangeStart >= subrangeEnd || lastRecord.targetAddress == 0L) continue;
            long translatedStart = lastRecord.translate(subrangeStart);
            long translatedEnd = lastRecord.translate(subrangeEnd);
            return Range.between(translatedStart, translatedEnd);
        }
        return null;
    }
}

